/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.IntRange;
import me.shedaniel.rei.impl.client.search.argument.AlternativeArgument;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.search.argument.type.AlwaysMatchingArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class Argument<T, R> {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final Short2ObjectMap<Long2ObjectMap<Object>> SEARCH_CACHE = Short2ObjectMaps.synchronize((Short2ObjectMap)new Short2ObjectOpenHashMap());
    private static final AtomicReference<String> lastLanguage = new AtomicReference();
    static final Argument<Unit, Unit> ALWAYS = new Argument<Unit, Unit>(AlwaysMatchingArgumentType.INSTANCE, "", true, -1, -1, true);
    private ArgumentType<T, R> argumentType;
    private String text;
    private T filterData;
    private boolean regular;
    private final int start;
    private final int end;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?:\"([^\"]*)\")|([^\\s]+)");

    public Argument(ArgumentType<T, R> argumentType, String text, boolean regular, int start, int end, boolean lowercase) {
        this.argumentType = argumentType;
        this.text = lowercase ? text.toLowerCase(Locale.ROOT) : text;
        this.regular = regular;
        this.filterData = null;
        this.start = start;
        this.end = end;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    @ApiStatus.Internal
    public static List<CompoundArgument> bakeArguments(String searchTerm) {
        return Argument.bakeArguments(searchTerm, null);
    }

    @ApiStatus.Internal
    public static List<CompoundArgument> bakeArguments(String searchTerm, @Nullable ProcessedSink sink) {
        ArrayList compoundArguments = Lists.newArrayList();
        int tokenStartIndex = 0;
        for (String token : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|")) {
            Matcher terms = SPLIT_PATTERN.matcher(token);
            CompoundArgument.Builder builder = CompoundArgument.builder();
            while (terms.find()) {
                AlternativeArgument.Builder alternativeBuilder = AlternativeArgument.builder();
                for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                    Argument.applyArgument(type, searchTerm, terms, tokenStartIndex, alternativeBuilder, true, sink);
                    if (alternativeBuilder.isEmpty()) continue;
                    break;
                }
                if (alternativeBuilder.isEmpty()) {
                    for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                        Argument.applyArgument(type, searchTerm, terms, tokenStartIndex, alternativeBuilder, false, sink);
                    }
                }
                builder.add(alternativeBuilder);
            }
            compoundArguments.add(builder.build());
            if (sink == null || (tokenStartIndex += 1 + token.length()) - 1 >= searchTerm.length()) continue;
            sink.addSplitter(tokenStartIndex - 1);
        }
        Argument.prepareSearchFilter(compoundArguments);
        return compoundArguments;
    }

    private static void prepareSearchFilter(List<CompoundArgument> compoundArguments) {
        for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument alternativeArgument = (AlternativeArgument)((Object)iterator.next());
                Iterator iterator2 = alternativeArgument.iterator();
                while (iterator2.hasNext()) {
                    Argument argument = (Argument)iterator2.next();
                    argument.filterData = argument.argumentType.prepareSearchFilter(argument.getText());
                }
            }
        }
    }

    private static void applyArgument(ArgumentType<?, ?> type, String searchTerm, Matcher terms, int tokenStartIndex, AlternativeArgument.Builder alternativeBuilder, boolean forceGrammar, @Nullable ProcessedSink sink) {
        String term = (String)MoreObjects.firstNonNull((Object)terms.group(1), (Object)terms.group(2));
        if (type.getSearchMode() == SearchMode.NEVER) {
            return;
        }
        ArgumentApplicableResult result = type.checkApplicable(term, forceGrammar);
        if (result.isApplicable()) {
            int group = terms.group(1) != null ? 1 : 2;
            Argument argument = new Argument(type, result.getText(), !result.isInverted(), terms.start(group) + tokenStartIndex, terms.end(group) + tokenStartIndex, !result.shouldPreserveCasing());
            alternativeBuilder.add(argument);
            if (sink != null) {
                if (group == 1) {
                    sink.addQuote(terms.start() + tokenStartIndex);
                    if (terms.end() - 1 + tokenStartIndex < searchTerm.length()) {
                        sink.addQuote(terms.end() - 1 + tokenStartIndex);
                    }
                }
                sink.addPart(argument, result.isUsingGrammar(), result.grammarRanges(), terms.start() + tokenStartIndex);
            }
        }
    }

    @ApiStatus.Internal
    public static boolean matches(EntryStack<?> stack, List<CompoundArgument> compoundArguments) {
        if (compoundArguments.isEmpty()) {
            return true;
        }
        String newLanguage = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        if (!Objects.equals(lastLanguage.getAndSet(newLanguage), newLanguage)) {
            SEARCH_CACHE.clear();
        }
        MutableObject mutable = new MutableObject();
        block0: for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument argument = (AlternativeArgument)((Object)iterator.next());
                if (Argument.matches(stack, argument, mutable)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static <T, R, Z, B> boolean matches(EntryStack<?> stack, AlternativeArgument alternativeArgument, Mutable<?> mutable) {
        if (alternativeArgument.isEmpty()) {
            return true;
        }
        long hashExact = EntryStacks.hashExact(stack);
        Iterator iterator = alternativeArgument.iterator();
        while (iterator.hasNext()) {
            Argument argument = (Argument)iterator.next();
            if (Argument.matches((short)argument.getArgument().getIndex(), argument.getArgument(), mutable, stack, hashExact, argument.getText(), argument.filterData) != argument.isRegular()) continue;
            return true;
        }
        return false;
    }

    private static <T, R, Z, B> boolean matches(short argumentIndex, ArgumentType<T, B> argumentType, Mutable<Z> data, EntryStack<?> stack, long hashExact, String filter, R filterData) {
        Long2ObjectMap map = (Long2ObjectMap)SEARCH_CACHE.get(argumentIndex);
        if (map == null) {
            map = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
            SEARCH_CACHE.put(argumentIndex, (Object)map);
        }
        Object value = map.get(hashExact);
        data.setValue(value);
        boolean matches = argumentType.matches(data, stack, filter, filterData);
        if (value == null) {
            map.put(hashExact, data.getValue());
        }
        return matches;
    }

    public ArgumentType<?, ?> getArgument() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isRegular() {
        return this.regular;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, regular = %b", this.argumentType.getName(), this.text, this.regular);
    }

    public static interface ProcessedSink {
        public void addQuote(int var1);

        public void addSplitter(int var1);

        public void addPart(Argument<?, ?> var1, boolean var2, Collection<IntRange> var3, int var4);
    }
}

