/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Collection;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TagArgumentType
extends ArgumentType<Unit, String[]> {
    public static final TagArgumentType INSTANCE = new TagArgumentType();
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Style STYLE = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)10420212));

    @Override
    public String getName() {
        return "tag";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "$";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTagSearchMode();
    }

    @Override
    public boolean matches(Mutable<String[]> data, EntryStack<?> stack, String searchText, Unit filterData) {
        if (data.getValue() == null) {
            Collection<ResourceLocation> tags = stack.getTagsFor();
            if (tags.isEmpty()) {
                data.setValue((Object)EMPTY_ARRAY);
            } else {
                data.setValue((Object)new String[tags.size()]);
                int i = 0;
                for (ResourceLocation identifier : tags) {
                    ((String[])data.getValue())[i] = identifier.toString();
                    ++i;
                }
            }
        }
        for (String tag : (String[])data.getValue()) {
            if (tag.isEmpty() || !tag.contains(searchText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private TagArgumentType() {
    }
}

