/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.ConcurrentModificationException;
import java.util.Locale;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.util.Unit;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TooltipArgumentType
extends ArgumentType<Unit, String> {
    public static final TooltipArgumentType INSTANCE = new TooltipArgumentType();
    private static final Style STYLE = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16769197));

    @Override
    public String getName() {
        return "tooltip";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "#";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTooltipSearchMode();
    }

    @Override
    public boolean matches(Mutable<String> data, EntryStack<?> stack, String searchText, Unit filterData) {
        String tooltip;
        if (data.getValue() == null) {
            tooltip = TooltipArgumentType.tryGetEntryStackTooltip(stack, 0);
            if (tooltip == null) {
                return false;
            }
            data.setValue((Object)tooltip.toLowerCase(Locale.ROOT));
        }
        return (tooltip = (String)data.getValue()).isEmpty() || tooltip.contains(searchText);
    }

    @Nullable
    public static String tryGetEntryStackTooltip(EntryStack<?> stack, int attempt) {
        try {
            Tooltip tooltip = stack.getTooltip(new Point(), false);
            if (tooltip != null) {
                return CollectionUtils.mapAndJoinToString(tooltip.getText(), ITextComponent::getString, (CharSequence)"\n");
            }
            return "";
        }
        catch (Throwable throwable) {
            Throwable temp = throwable;
            while (temp != null) {
                if (!((temp = temp.getCause()) instanceof ConcurrentModificationException)) continue;
                if (attempt < 10) {
                    return TooltipArgumentType.tryGetEntryStackTooltip(stack, attempt + 1);
                }
                return null;
            }
            throw throwable;
        }
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private TooltipArgumentType() {
    }
}

