/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.plugins;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.util.Pair;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.UnaryOperator;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.GameInstance;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PluginManagerImpl<P extends REIPlugin<?>>
implements PluginManager<P>,
PluginView<P> {
    private final List<Reloadable<P>> reloadables = new ArrayList<Reloadable<P>>();
    private final Map<Class<? extends Reloadable<P>>, Reloadable<? super P>> cache = new ConcurrentHashMap<Class<? extends Reloadable<P>>, Reloadable<? super P>>();
    private final Class<P> pluginClass;
    private final UnaryOperator<PluginView<P>> view;
    private boolean reloading = false;
    private final List<REIPluginProvider<P>> plugins = new ArrayList<REIPluginProvider<P>>();
    private final LongConsumer reloadDoneListener;

    @SafeVarargs
    public PluginManagerImpl(Class<P> pluginClass, UnaryOperator<PluginView<P>> view, LongConsumer reloadDoneListener, Reloadable<? extends P> ... reloadables) {
        this.pluginClass = pluginClass;
        this.view = view;
        this.reloadDoneListener = reloadDoneListener;
        for (Reloadable<? extends P> reloadable : reloadables) {
            this.registerReloadable(reloadable);
        }
    }

    @Override
    public void registerReloadable(Reloadable<? extends P> reloadable) {
        this.reloadables.add(reloadable);
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public <T extends Reloadable<? super P>> T get(Class<T> reloadableClass) {
        Reloadable<? super P> reloadable = this.cache.get(reloadableClass);
        if (reloadable != null) {
            return (T)reloadable;
        }
        for (Reloadable<P> r : this.reloadables) {
            if (!reloadableClass.isInstance(r)) continue;
            this.cache.put(reloadableClass, r);
            return (T)r;
        }
        throw new IllegalArgumentException("Unknown reloadable type! " + reloadableClass.getName());
    }

    @Override
    public List<Reloadable<P>> getReloadables() {
        return Collections.unmodifiableList(this.reloadables);
    }

    @Override
    public PluginView<P> view() {
        return (PluginView)this.view.apply(this);
    }

    @Override
    public void registerPlugin(REIPluginProvider<? extends P> plugin) {
        this.plugins.add(plugin);
        RoughlyEnoughItemsCore.LOGGER.info("Registered plugin provider %s for %s", plugin.getPluginProviderName(), PluginManagerImpl.name(this.pluginClass));
    }

    @Override
    public List<REIPluginProvider<P>> getPluginProviders() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    public FluentIterable<P> getPlugins() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, REIPluginProvider::provide));
    }

    public FluentIterable<PluginWrapper<P>> getPluginWrapped() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, input -> Iterables.transform(input.provide(), plugin -> new PluginWrapper<REIPlugin>((REIPlugin)plugin, (REIPluginProvider<REIPlugin>)input))));
    }

    private SectionClosable section(ReloadStage stage, String section) {
        return new SectionClosable(stage, section);
    }

    private void pluginSection(ReloadStage stage, String sectionName, List<PluginWrapper<P>> list, @Nullable Reloadable<?> reloadable, Consumer<PluginWrapper<P>> consumer) {
        for (PluginWrapper wrapper : list) {
            try {
                SectionClosable section = this.section(stage, sectionName + wrapper.getPluginProviderName() + "/");
                try {
                    if (reloadable == null || !wrapper.plugin.shouldBeForcefullyDoneOnMainThread(reloadable)) {
                        consumer.accept(wrapper);
                        continue;
                    }
                    RoughlyEnoughItemsCore.LOGGER.warn("Forcing plugin " + wrapper.getPluginProviderName() + " to run on the main thread for " + sectionName + "! This is extremely dangerous, and have large performance implications.");
                    if (Platform.getEnvironment() == Env.CLIENT) {
                        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> this.queueExecutionClient(() -> consumer.accept(wrapper)));
                        continue;
                    }
                    this.queueExecution(() -> consumer.accept(wrapper));
                }
                finally {
                    if (section == null) continue;
                    section.close();
                }
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error(wrapper.getPluginProviderName() + " plugin failed to " + sectionName + "!", throwable);
            }
        }
    }

    private void queueExecution(Runnable runnable) {
        MinecraftServer server = GameInstance.getServer();
        if (server != null) {
            server.func_213167_f(runnable);
        }
    }

    private void queueExecutionClient(Runnable runnable) {
        Minecraft.func_71410_x().func_213167_f(runnable);
    }

    @Override
    public void pre(ReloadStage stage) {
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        try (SectionClosable preRegister = this.section(stage, "pre-register/");
             PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Pre Registration");){
            this.pluginSection(stage, "pre-register/", plugins, null, plugin -> {
                try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair((Object)((PluginWrapper)plugin).provider, (Object)((PluginWrapper)plugin).plugin));){
                    ((PluginWrapper)plugin).plugin.preRegister();
                    ((PluginWrapper)plugin).plugin.preStage(this, stage);
                }
            });
        }
        catch (Throwable throwable) {
            new RuntimeException("Failed to run pre registration").printStackTrace();
        }
    }

    @Override
    public void post(ReloadStage stage) {
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        try (SectionClosable postRegister = this.section(stage, "post-register/");
             PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Post Registration");){
            this.pluginSection(stage, "post-register/", plugins, null, plugin -> {
                try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair((Object)((PluginWrapper)plugin).provider, (Object)((PluginWrapper)plugin).plugin));){
                    ((PluginWrapper)plugin).plugin.postRegister();
                    ((PluginWrapper)plugin).plugin.postStage(this, stage);
                }
            });
        }
        catch (Throwable throwable) {
            new RuntimeException("Failed to run post registration").printStackTrace();
        }
    }

    private static String name(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            return clazz.getName();
        }
        return simpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReload(ReloadStage stage) {
        try {
            this.reloading = true;
            long startTime = Util.func_211177_b();
            try (SectionClosable startReloadAll = this.section(stage, "start-reload/");
                 PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Initialization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    Class<?> reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable startReload = this.section(stage, "start-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            PerformanceLogger.Plugin.Inner inner = perfLogger.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.startReload(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (startReload == null) continue;
                            startReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
            plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
            RoughlyEnoughItemsCore.LOGGER.info("Reloading Plugin Manager [%s] stage [%s], registered %d plugins: %s", PluginManagerImpl.name(this.pluginClass), stage.toString(), plugins.size(), CollectionUtils.mapAndJoinToString(plugins, PluginWrapper::getPluginProviderName, (CharSequence)", "));
            Collections.reverse(plugins);
            for (Reloadable reloadable : this.getReloadables()) {
                Class<?> reloadableClass = reloadable.getClass();
                SectionClosable reloadablePlugin = this.section(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/");
                try {
                    PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage(PluginManagerImpl.name(reloadableClass));
                    try {
                        this.pluginSection(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/", plugins, reloadable, plugin -> {
                            try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair((Object)((PluginWrapper)plugin).provider, (Object)((PluginWrapper)plugin).plugin));){
                                reloadable.acceptPlugin(((PluginWrapper)plugin).plugin, stage);
                            }
                        });
                    }
                    finally {
                        if (perfLogger == null) continue;
                        perfLogger.close();
                    }
                }
                finally {
                    if (reloadablePlugin == null) continue;
                    reloadablePlugin.close();
                }
            }
            try (SectionClosable endReloadAll = this.section(stage, "end-reload/");
                 PerformanceLogger.Plugin plugin2 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Finalization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    Class<?> reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable endReload = this.section(stage, "end-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            PerformanceLogger.Plugin.Inner inner = plugin2.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.endReload(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (endReload == null) continue;
                            endReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            long usedTime = Util.func_211177_b() - startTime;
            this.reloadDoneListener.accept(usedTime);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.reloading = false;
        }
    }

    private static class SectionClosable
    implements Closeable {
        private ReloadStage stage;
        private MutablePair<Stopwatch, String> sectionData;

        public SectionClosable(ReloadStage stage, String section) {
            this.stage = stage;
            this.sectionData = new MutablePair((Object)Stopwatch.createUnstarted(), (Object)"");
            this.sectionData.setRight((Object)section);
            RoughlyEnoughItemsCore.LOGGER.debug("[" + (Object)((Object)stage) + "] Reloading Section: \"%s\"", section);
            ((Stopwatch)this.sectionData.getLeft()).reset().start();
        }

        @Override
        public void close() {
            ((Stopwatch)this.sectionData.getLeft()).stop();
            String section = (String)this.sectionData.getRight();
            RoughlyEnoughItemsCore.LOGGER.debug("[" + (Object)((Object)this.stage) + "] Reloading Section: \"%s\" done in %s", section, ((Stopwatch)this.sectionData.getLeft()).toString());
            ((Stopwatch)this.sectionData.getLeft()).reset();
        }
    }

    private static class PluginWrapper<P extends REIPlugin<?>> {
        private final P plugin;
        private final REIPluginProvider<P> provider;

        public PluginWrapper(P plugin, REIPluginProvider<P> provider) {
            this.plugin = plugin;
            this.provider = provider;
        }

        public double getPriority() {
            return this.plugin.getPriority();
        }

        public String getPluginProviderName() {
            return this.provider.getPluginProviderName();
        }
    }
}

