/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.jetbrains.annotations.NotNull;

public class JEIDrawableBuilder
implements IDrawableBuilder {
    private ResourceLocation texture;
    private int u;
    private int v;
    private int width;
    private int height;
    private int textureWidth = 256;
    private int textureHeight = 256;
    private int paddingTop;
    private int paddingBottom;
    private int paddingLeft;
    private int paddingRight;

    public JEIDrawableBuilder(ResourceLocation texture, int u, int v, int width, int height) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public IDrawableBuilder setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder addPadding(int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder trim(int trimTop, int trimBottom, int trimLeft, int trimRight) {
        this.u += trimLeft;
        this.v += trimTop;
        this.width -= trimLeft + trimRight;
        this.height -= trimTop + trimBottom;
        return this;
    }

    @Override
    @NotNull
    public IDrawableStatic build() {
        final int actualWidth = this.width + this.paddingLeft + this.paddingRight;
        final int actualHeight = this.height + this.paddingTop + this.paddingBottom;
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(JEIDrawableBuilder.this.texture);
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                int xStart = xOffset + JEIDrawableBuilder.this.paddingLeft + maskLeft;
                int yStart = yOffset + JEIDrawableBuilder.this.paddingTop + maskTop;
                int u = JEIDrawableBuilder.this.u + maskLeft;
                int v = JEIDrawableBuilder.this.v + maskTop;
                int width = JEIDrawableBuilder.this.width - maskRight - maskLeft;
                int height = JEIDrawableBuilder.this.height - maskBottom - maskTop;
                float f = 1.0f / (float)JEIDrawableBuilder.this.textureWidth;
                float f1 = 1.0f / (float)JEIDrawableBuilder.this.textureHeight;
                float z = 0.0f;
                float xEnd = xStart + width;
                float yEnd = yStart + height;
                float uStart = (float)u * f;
                float uEnd = (float)(u + width) * f;
                float vStart = (float)v * f1;
                float vEnd = (float)(v + height) * f1;
                bufferBuilder.func_227888_a_(matrix, (float)xStart, yEnd, z).func_225583_a_(uStart, vEnd).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, xEnd, yEnd, z).func_225583_a_(uEnd, vEnd).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, xEnd, (float)yStart, z).func_225583_a_(uEnd, vStart).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, (float)xStart, (float)yStart, z).func_225583_a_(uStart, vStart).func_181675_d();
                bufferBuilder.func_178977_d();
                RenderSystem.enableAlphaTest();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
                this.draw(matrixStack, xOffset, yOffset, 0, 0, 0, 0);
            }

            @Override
            public int getWidth() {
                return actualWidth;
            }

            @Override
            public int getHeight() {
                return actualHeight;
            }
        };
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(int ticksPerCycle, @NotNull IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        return JEIGuiHelper.INSTANCE.createAnimatedDrawable(this.build(), ticksPerCycle, startDirection, inverted);
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(@NotNull ITickTimer tickTimer, @NotNull IDrawableAnimated.StartDirection startDirection) {
        throw JEIPluginDetector.TODO();
    }
}

