/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.ImmutableList;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientListOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JEIIngredientListOverlay implements IIngredientListOverlay
{
    INSTANCE;


    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return null;
        }
        ScreenOverlay overlay = REIRuntime.getInstance().getOverlay().get();
        EntryStack<?> stack = overlay.getEntryList().getFocusedStack();
        if (stack.isEmpty()) {
            return null;
        }
        return JEIPluginDetector.jeiValue(stack);
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(@NotNull IIngredientType<T> ingredientType) {
        Object underMouse = this.getIngredientUnderMouse();
        if (underMouse == null) {
            return null;
        }
        if (ingredientType.getIngredientClass().isInstance(underMouse.getClass())) {
            return (T)underMouse;
        }
        return null;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return REIRuntime.getInstance().isOverlayVisible() && REIRuntime.getInstance().getSearchTextField().isFocused();
    }

    @Override
    @NotNull
    public ImmutableList<Object> getVisibleIngredients() {
        if (REIRuntime.getInstance().isOverlayVisible()) {
            ScreenOverlay overlay = REIRuntime.getInstance().getOverlay().get();
            return (ImmutableList)overlay.getEntryList().getEntries().map(JEIPluginDetector::jeiValue).collect(ImmutableList.toImmutableList());
        }
        return null;
    }
}

