/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.plugin.autocrafting.DefaultRecipeBookHandler;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.client.categories.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultFuelCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultInformationCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultPathingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultSmithingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.client.categories.DefaultTillingCategory;
import me.shedaniel.rei.plugin.client.categories.anvil.DefaultAnvilCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconBaseCategory;
import me.shedaniel.rei.plugin.client.categories.beacon.DefaultBeaconPaymentCategory;
import me.shedaniel.rei.plugin.client.categories.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.client.categories.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultPotionEffectExclusionZones;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultRecipeBookExclusionZones;
import me.shedaniel.rei.plugin.client.favorites.GameModeFavoriteEntry;
import me.shedaniel.rei.plugin.client.favorites.WeatherFavoriteEntry;
import me.shedaniel.rei.plugin.client.forge.DefaultClientPluginImpl;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComposterBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screen.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.FurnaceScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.screen.inventory.SmokerScreen;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientPlugin
implements REIClientPlugin,
BuiltinClientPlugin {
    public DefaultClientPlugin() {
        ClientInternals.attachInstance(() -> this, "builtinClientPlugin");
    }

    @Override
    public void registerBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        DisplayRegistry.getInstance().add(new BrewingRecipe(input, ingredient, output));
    }

    @Override
    public void registerInformation(EntryIngredient ingredient, ITextComponent name, UnaryOperator<List<ITextComponent>> textBuilder) {
        DisplayRegistry.getInstance().add(DefaultInformationDisplay.createFromEntries(ingredient, name).lines((Collection)textBuilder.apply(Lists.newArrayList())));
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        for (Item item : Registry.field_212630_s) {
            try {
                registry.addEntries(EntryIngredients.ofItemStacks(registry.appendStacksForItem(item)));
            }
            catch (Exception ignored) {
                registry.addEntry(EntryStacks.of((IItemProvider)item));
            }
        }
        for (Fluid fluid : Registry.field_212619_h) {
            FluidState state = fluid.func_207188_f();
            if (state.func_206888_e() || !state.func_206889_d()) continue;
            registry.addEntry(EntryStacks.of(fluid));
        }
    }

    @Override
    public void registerCategories(CategoryRegistry registry) {
        ITag shovelsTag;
        ITag hoesTag;
        registry.add(new DefaultCraftingCategory(), new DefaultCookingCategory(SMELTING, EntryStacks.of((IItemProvider)Items.field_221738_ce), "category.rei.smelting"), new DefaultCookingCategory(SMOKING, EntryStacks.of((IItemProvider)Items.field_222101_pH), "category.rei.smoking"), new DefaultCookingCategory(BLASTING, EntryStacks.of((IItemProvider)Items.field_222102_pI), "category.rei.blasting"), new DefaultCampfireCategory(), new DefaultStoneCuttingCategory(), new DefaultFuelCategory(), new DefaultBrewingCategory(), new DefaultCompostingCategory(), new DefaultStrippingCategory(), new DefaultSmithingCategory(), new DefaultAnvilCategory(), new DefaultBeaconBaseCategory(), new DefaultBeaconPaymentCategory(), new DefaultTillingCategory(), new DefaultPathingCategory(), new DefaultInformationCategory());
        registry.removePlusButton(FUEL);
        registry.removePlusButton(COMPOSTING);
        registry.removePlusButton(BEACON_BASE);
        registry.removePlusButton(BEACON_PAYMENT);
        registry.removePlusButton(INFO);
        registry.removePlusButton(STRIPPING);
        registry.removePlusButton(TILLING);
        registry.removePlusButton(PATHING);
        registry.addWorkstations(CRAFTING, EntryStacks.of((IItemProvider)Items.field_221734_cc));
        registry.addWorkstations(SMELTING, EntryStacks.of((IItemProvider)Items.field_221738_ce));
        registry.addWorkstations(SMOKING, EntryStacks.of((IItemProvider)Items.field_222101_pH));
        registry.addWorkstations(BLASTING, EntryStacks.of((IItemProvider)Items.field_222102_pI));
        registry.addWorkstations(CAMPFIRE, EntryStacks.of((IItemProvider)Items.field_222113_pS), EntryStacks.of((IItemProvider)Items.field_234791_rn_));
        registry.addWorkstations(FUEL, EntryStacks.of((IItemProvider)Items.field_221738_ce), EntryStacks.of((IItemProvider)Items.field_222101_pH), EntryStacks.of((IItemProvider)Items.field_222102_pI));
        registry.addWorkstations(BREWING, EntryStacks.of((IItemProvider)Items.field_222088_mr));
        registry.addWorkstations(ANVIL, EntryStacks.of((IItemProvider)Items.field_221844_ef));
        registry.addWorkstations(STONE_CUTTING, EntryStacks.of((IItemProvider)Items.field_222108_pO));
        registry.addWorkstations(COMPOSTING, EntryStacks.of((IItemProvider)Items.field_222035_iX));
        registry.addWorkstations(SMITHING, EntryStacks.of((IItemProvider)Items.field_222107_pN));
        registry.addWorkstations(BEACON_BASE, EntryStacks.of((IItemProvider)Items.field_221749_dK));
        registry.addWorkstations(BEACON_PAYMENT, EntryStacks.of((IItemProvider)Items.field_221749_dK));
        HashSet axes = Sets.newHashSet();
        HashSet hoes = Sets.newHashSet();
        HashSet shovels = Sets.newHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getValueType() == ItemStack.class).map(stack -> ((ItemStack)stack.getValue()).func_77973_b()).forEach(item -> {
            if (item instanceof AxeItem && axes.add(item)) {
                registry.addWorkstations(STRIPPING, EntryStacks.of((IItemProvider)item));
            }
            if (item instanceof HoeItem && hoes.add(item)) {
                registry.addWorkstations(TILLING, EntryStacks.of((IItemProvider)item));
            }
            if (item instanceof ShovelItem && shovels.add(item)) {
                registry.addWorkstations(PATHING, EntryStacks.of((IItemProvider)item));
            }
        });
        ITagCollection itemTagCollection = Minecraft.func_71410_x().func_147114_u().func_199724_l().func_241836_b();
        ITag axesTag = itemTagCollection.func_199910_a(new ResourceLocation("c", "axes"));
        if (axesTag != null) {
            for (Object item2 : axesTag.func_230236_b_()) {
                if (!axes.add(item2)) continue;
                registry.addWorkstations(STRIPPING, EntryStacks.of((IItemProvider)item2));
            }
        }
        if ((hoesTag = itemTagCollection.func_199910_a(new ResourceLocation("c", "hoes"))) != null) {
            for (Item item3 : hoesTag.func_230236_b_()) {
                if (!hoes.add(item3)) continue;
                registry.addWorkstations(TILLING, EntryStacks.of((IItemProvider)item3));
            }
        }
        if ((shovelsTag = itemTagCollection.func_199910_a(new ResourceLocation("c", "shovels"))) != null) {
            for (Item item4 : shovelsTag.func_230236_b_()) {
                if (!shovels.add(item4)) continue;
                registry.addWorkstations(PATHING, EntryStacks.of((IItemProvider)item4));
            }
        }
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(ICraftingRecipe.class, IRecipeType.field_222149_a, DefaultCraftingDisplay::of);
        registry.registerRecipeFiller(FurnaceRecipe.class, IRecipeType.field_222150_b, DefaultSmeltingDisplay::new);
        registry.registerRecipeFiller(SmokingRecipe.class, IRecipeType.field_222152_d, DefaultSmokingDisplay::new);
        registry.registerRecipeFiller(BlastingRecipe.class, IRecipeType.field_222151_c, DefaultBlastingDisplay::new);
        registry.registerRecipeFiller(CampfireCookingRecipe.class, IRecipeType.field_222153_e, DefaultCampfireDisplay::new);
        registry.registerRecipeFiller(StonecuttingRecipe.class, IRecipeType.field_222154_f, DefaultStoneCuttingDisplay::new);
        registry.registerRecipeFiller(SmithingRecipe.class, IRecipeType.field_234827_g_, DefaultSmithingDisplay::new);
        registry.registerFiller(AnvilRecipe.class, DefaultAnvilDisplay::new);
        registry.registerFiller(BrewingRecipe.class, DefaultBrewingDisplay::new);
        for (Map.Entry entry2 : AbstractFurnaceTileEntity.func_214001_f().entrySet()) {
            registry.add(new DefaultFuelDisplay(Collections.singletonList(EntryIngredients.of((IItemProvider)entry2.getKey())), Collections.emptyList(), (Integer)entry2.getValue()));
        }
        EntryIngredient arrowStack = EntryIngredient.of(EntryStacks.of((IItemProvider)Items.field_151032_g));
        ReferenceOpenHashSet registeredPotions = new ReferenceOpenHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(entry -> entry.getValueType() == ItemStack.class && ((ItemStack)entry.castValue()).func_77973_b() == Items.field_185156_bI).forEach(arg_0 -> DefaultClientPlugin.lambda$registerDisplays$5((ReferenceSet)registeredPotions, arrowStack, registry, arg_0));
        if (ComposterBlock.field_220299_b.isEmpty()) {
            ComposterBlock.func_220297_d();
        }
        int page = 0;
        UnmodifiableIterator iterator = Iterators.partition(ComposterBlock.field_220299_b.object2FloatEntrySet().stream().sorted(Map.Entry.comparingByValue()).iterator(), (int)48);
        while (iterator.hasNext()) {
            List entries = (List)iterator.next();
            registry.add(DefaultCompostingDisplay.of(entries, Collections.singletonList(EntryIngredients.of(new ItemStack((IItemProvider)Items.field_196106_bc))), page++));
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> Registry.field_212618_g.func_177774_c((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultStrippingDisplay(EntryStacks.of((IItemProvider)set.getKey()), EntryStacks.of((IItemProvider)set.getValue()))));
        DummyShovelItem.getPathBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> Registry.field_212618_g.func_177774_c((Object)((Block)b.getKey())))).forEach(set -> registry.add(new DefaultPathingDisplay(EntryStacks.of((IItemProvider)set.getKey()), EntryStacks.of((IItemProvider)((BlockState)set.getValue()).func_177230_c()))));
        registry.add(new DefaultBeaconBaseDisplay(CollectionUtils.map(Lists.newArrayList((Iterable)BlockTags.field_232875_ap_.func_230236_b_()), ItemStack::new)));
        registry.add(new DefaultBeaconPaymentDisplay(CollectionUtils.map(Lists.newArrayList((Iterable)ItemTags.field_232908_Z_.func_230236_b_()), ItemStack::new)));
        if (Platform.isFabric()) {
            ItemStack output;
            Ingredient base;
            Potion to;
            Ingredient ingredient;
            Potion from;
            LinkedHashSet potions = Sets.newLinkedHashSet();
            for (Ingredient container : PotionBrewing.field_185215_c) {
                for (PotionBrewing.MixPredicate mix : PotionBrewing.field_185213_a) {
                    from = (Potion)mix.from;
                    ingredient = mix.field_185199_b;
                    to = (Potion)mix.to;
                    base = Ingredient.func_234819_a_(Arrays.stream(container.func_193365_a()).map(ItemStack::func_77946_l).map(stack -> PotionUtils.func_185188_a((ItemStack)stack, (Potion)from)));
                    output = Arrays.stream(container.func_193365_a()).map(ItemStack::func_77946_l).map(stack -> PotionUtils.func_185188_a((ItemStack)stack, (Potion)to)).findFirst().orElse(ItemStack.field_190927_a);
                    this.registerBrewingRecipe(base, ingredient, output);
                    potions.add(from);
                    potions.add(to);
                }
            }
            for (Potion potion : potions) {
                for (PotionBrewing.MixPredicate mix : PotionBrewing.field_185214_b) {
                    from = (Item)mix.from;
                    ingredient = mix.field_185199_b;
                    to = (Item)mix.to;
                    base = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)from), (Potion)potion)});
                    output = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)to), (Potion)potion);
                    this.registerBrewingRecipe(base, ingredient, output);
                }
            }
        } else {
            DefaultClientPlugin.registerForgePotions(registry, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    private static void registerForgePotions(DisplayRegistry registry, BuiltinClientPlugin clientPlugin) {
        void var1_1;
        DefaultClientPluginImpl.registerForgePotions(registry, (BuiltinClientPlugin)var1_1);
    }

    @Override
    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(DisplayEffectsScreen.class, new DefaultPotionEffectExclusionZones());
        zones.register(IRecipeShownListener.class, new DefaultRecipeBookExclusionZones());
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new DisplayBoundsProvider<ContainerScreen<?>>(){

            @Override
            public Rectangle getScreenBounds(ContainerScreen<?> screen) {
                return new Rectangle(screen.field_147003_i, screen.field_147009_r, screen.field_146999_f, screen.field_147000_g);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return ContainerScreen.class.isAssignableFrom(screen);
            }
        });
        registry.registerContainerClickArea(new Rectangle(88, 32, 28, 23), CraftingScreen.class, CRAFTING);
        registry.registerContainerClickArea(new Rectangle(137, 29, 10, 13), InventoryScreen.class, CRAFTING);
        registry.registerContainerClickArea(new Rectangle(97, 16, 14, 30), BrewingStandScreen.class, BREWING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), FurnaceScreen.class, SMELTING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), SmokerScreen.class, SMOKING);
        registry.registerContainerClickArea(new Rectangle(78, 32, 28, 23), BlastFurnaceScreen.class, BLASTING);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultRecipeBookHandler());
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(GameModeFavoriteEntry.ID, GameModeFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((ITextComponent)new TranslationTextComponent("favorite.section.gamemode")).add((FavoriteEntry[])Stream.concat(Arrays.stream(GameType.values()).filter(type -> type.func_77148_a() >= 0), Stream.of((GameType)null)).map(GameModeFavoriteEntry::new).toArray(FavoriteEntry[]::new));
        registry.register(WeatherFavoriteEntry.ID, WeatherFavoriteEntry.Type.INSTANCE);
        registry.getOrCrateSection((ITextComponent)new TranslationTextComponent("favorite.section.weather")).add((FavoriteEntry[])Stream.concat(Arrays.stream(WeatherFavoriteEntry.Weather.values()), Stream.of((WeatherFavoriteEntry.Weather)null)).map(WeatherFavoriteEntry::new).toArray(FavoriteEntry[]::new));
    }

    @Override
    public double getPriority() {
        return -100.0;
    }

    private static /* synthetic */ void lambda$registerDisplays$5(ReferenceSet registeredPotions, EntryIngredient arrowStack, DisplayRegistry registry, EntryStack entry) {
        ItemStack itemStack = (ItemStack)entry.getValue();
        Potion potion = PotionUtils.func_185191_c((ItemStack)itemStack);
        if (registeredPotions.add((Object)potion)) {
            int i;
            ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            input.add(EntryIngredients.of(itemStack));
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            ItemStack outputStack = new ItemStack((IItemProvider)Items.field_185167_i, 8);
            PotionUtils.func_185188_a((ItemStack)outputStack, (Potion)potion);
            PotionUtils.func_185184_a((ItemStack)outputStack, (Collection)PotionUtils.func_185190_b((ItemStack)itemStack));
            EntryIngredient output = EntryIngredients.of(outputStack);
            registry.add(new DefaultCustomDisplay(null, input, Collections.singletonList(output)));
        }
    }

    public static class DummyAxeItem
    extends AxeItem {
        public DummyAxeItem(IItemTier tier, float f, float g, Item.Properties properties) {
            super(tier, f, g, properties);
        }

        public static Map<Block, Block> getStrippedBlocksMap() {
            return field_203176_a;
        }
    }

    public static class DummyShovelItem
    extends ShovelItem {
        public DummyShovelItem(IItemTier tier, float f, float g, Item.Properties properties) {
            super(tier, f, g, properties);
        }

        public static Map<Block, BlockState> getPathBlocksMap() {
            return field_195955_e;
        }
    }
}

