/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.forge.DefaultCraftingDisplayImpl;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCraftingDisplay<C extends IRecipe<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe) {
        super(inputs, outputs, Optional.empty());
        this.recipe = recipe;
    }

    @Nullable
    public static DefaultCraftingDisplay<?> of(IRecipe<?> recipe) {
        if (recipe instanceof ShapelessRecipe) {
            return new DefaultShapelessDisplay((ShapelessRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipe) {
            return new DefaultShapedDisplay((ShapedRecipe)recipe);
        }
        if (!recipe.func_192399_d()) {
            Pair<Integer, Integer> size;
            NonNullList ingredients = recipe.func_192400_c();
            Pair<Integer, Integer> pair = size = Platform.isFabric() ? null : DefaultCraftingDisplay.getSize(recipe);
            if (!ingredients.isEmpty()) {
                if (size == null) {
                    return new DefaultCustomDisplay(recipe, EntryIngredients.ofIngredients((List<Ingredient>)recipe.func_192400_c()), Collections.singletonList(EntryIngredients.of(recipe.func_77571_b())));
                }
                return new DefaultCustomShapedDisplay(recipe, EntryIngredients.ofIngredients((List<Ingredient>)recipe.func_192400_c()), Collections.singletonList(EntryIngredients.of(recipe.func_77571_b())), (Integer)size.getLeft(), (Integer)size.getRight());
            }
        }
        return null;
    }

    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    private static Pair<Integer, Integer> getSize(IRecipe<?> recipe) {
        return DefaultCraftingDisplayImpl.getSize(recipe);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return this.getOptionalRecipe().map(IRecipe::func_199560_c);
    }

    public <T extends Container> List<List<ItemStack>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap(ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends Container> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultCraftingDisplay.getSlotWithSize(display.getWidth(), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<DefaultCraftingDisplay<?>> serializer() {
        return BasicDisplay.Serializer.ofSimple(DefaultCustomDisplay::simple).inputProvider(display -> display.getOrganisedInputEntries(3, 3));
    }

    @Override
    public List<EntryIngredient> getInputEntries(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(9);
        for (int i = 0; i < 9; ++i) {
            list.add(EntryIngredient.empty());
        }
        List<EntryIngredient> inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, 3), inputEntries.get(i));
        }
        return list;
    }
}

