/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DefaultCustomDisplay
extends DefaultCraftingDisplay<IRecipe<?>> {
    private int width;
    private int height;

    public DefaultCustomDisplay(@Nullable IRecipe<?> possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
        super(input, output, Optional.ofNullable(possibleRecipe));
        BitSet row = new BitSet(3);
        BitSet column = new BitSet(3);
        for (int i = 0; i < 9; ++i) {
            EntryIngredient stacks;
            if (i >= input.size() || !(stacks = input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
            row.set((i - i % 3) / 3);
            column.set(i % 3);
        }
        this.width = column.cardinality();
        this.height = row.cardinality();
    }

    public static DefaultCustomDisplay simple(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location) {
        IRecipe optionalRecipe = location.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().func_215367_a(resourceLocation)).orElse(null);
        return new DefaultCustomDisplay(optionalRecipe, input, output);
    }

    @Override
    public List<EntryIngredient> getInputEntries(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        if (fill && info instanceof SimpleGridMenuInfo) {
            ArrayList<EntryIngredient> out = new ArrayList<EntryIngredient>();
            int craftingWidth = ((SimpleGridMenuInfo)info).getCraftingWidth(context.getMenu());
            int craftingHeight = ((SimpleGridMenuInfo)info).getCraftingHeight(context.getMenu());
            for (int i = 0; i < 9; ++i) {
                int x;
                if (i >= this.inputs.size() || (x = i % 3) >= craftingWidth) continue;
                out.add((EntryIngredient)this.inputs.get(i));
                if (out.size() > craftingWidth * craftingHeight) break;
            }
            while (out.size() < craftingWidth * craftingHeight) {
                out.add(EntryIngredient.empty());
            }
            return out;
        }
        return super.getInputEntries(context, info, fill);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

