/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.test;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.TestOnly;

@OnlyIn(value=Dist.CLIENT)
@TestOnly
public class REITestPlugin
implements REIClientPlugin {
    private Random random = new Random();

    @Override
    public void preRegister() {
        LogManager.getLogger().error("REI Test Plugin is enabled! If you see this unintentionally, please report this!");
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        int times = 100;
        for (Item item : Registry.field_212630_s) {
            EntryStack<ItemStack> base = EntryStacks.of((IItemProvider)item);
            registry.addEntriesAfter(base, IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of((IItemProvider)item))).collect(Collectors.toList()));
            try {
                for (ItemStack stack : registry.appendStacksForItem(item)) {
                    registry.addEntries(IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of(stack))).collect(Collectors.toList()));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt((Item[])Registry.field_212630_s.func_201756_e().toArray(Item[]::new));
    }

    public EntryStack<ItemStack> transformStack(EntryStack<ItemStack> stack) {
        CompoundNBT tag = stack.getValue().func_196082_o();
        tag.func_74768_a("Whatever", this.random.nextInt(Integer.MAX_VALUE));
        return stack;
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.registerSystemFavorites(() -> {
            GameType mode = Minecraft.func_71410_x().field_71442_b.func_178889_l();
            switch (mode) {
                case SURVIVAL: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((IItemProvider)Items.field_221574_b)));
                }
                case CREATIVE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((IItemProvider)Items.field_221898_fg)));
                }
                case ADVENTURE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((IItemProvider)Items.field_221844_ef)));
                }
            }
            return ImmutableList.of();
        });
    }
}

