/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import java.util.List;
import java.util.function.Supplier;

public class CompositeRichText
implements IRichText {
    private final IRichText[] _components;
    private final int _count;
    private final Rectangle _bounds;
    private final int _interline;
    private final int _margin;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void paint(MatrixStack matrix, int x, int y, int zLevel) {
        x += this._margin;
        y += this._margin;
        for (int i = 0; i < this._count; ++i) {
            IRichText text = this._components[i];
            text.paint(matrix, x, y, zLevel);
            y += text.bounds().Height + this._interline;
        }
    }

    @Override
    public Rectangle bounds() {
        return this._bounds;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._count;
    }

    @Override
    public boolean isNotEmpty() {
        return this._count > 0;
    }

    private CompositeRichText(List<IRichText> components, int interline, int margin) {
        if (!components.isEmpty()) {
            int width = 0;
            int height = margin * 2 + (components.size() - 1) * interline;
            for (IRichText text : components) {
                Rectangle bounds = text.bounds();
                if (bounds.Width > width) {
                    width = bounds.Width;
                }
                height += bounds.Height;
            }
            this._components = components.toArray(new IRichText[0]);
            this._count = this._components.length;
            this._bounds = new Rectangle(0, 0, width += margin * 2, height);
        } else {
            this._components = new IRichText[0];
            this._count = 0;
            this._bounds = Rectangle.ZERO;
        }
        this._interline = interline;
        this._margin = margin;
    }

    public static class Builder {
        private final List<IRichText> _components = Lists.newArrayList();
        private int _interline = 0;
        private int _margin = 0;

        public CompositeRichText build() {
            return new CompositeRichText(this._components, this._interline, this._margin);
        }

        public Builder add(IRichText richText) {
            if (richText.isNotEmpty()) {
                this._components.add(richText);
            }
            return this;
        }

        public Builder add(Supplier<IRichText> richTextSupplier) {
            return this.add(richTextSupplier.get());
        }

        public Builder interline(int interline) {
            this._interline = interline;
            return this;
        }

        public Builder margin(int margin) {
            this._margin = margin;
            return this;
        }

        protected Builder() {
        }
    }
}

