/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import java.util.Optional;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.common.util.NonNullConsumer;

public interface ISprite {
    public int getWidth();

    public int getHeight();

    public int getU();

    public int getV();

    public float getMinU();

    public float getMaxU();

    public float getMinV();

    public float getMaxV();

    default public float getInterpolatedU(double u) {
        return this.getMinU() + (this.getMaxU() - this.getMinU()) * (float)u / 16.0f;
    }

    default public float getInterpolatedV(double v) {
        return this.getMinV() + (this.getMaxV() - this.getMinV()) * (float)v / 16.0f;
    }

    default public Optional<TextureAtlasSprite> getAtlasSprite() {
        return Optional.empty();
    }

    public ISpriteTextureMap getTextureMap();

    public Optional<ISprite> getSpriteOverlay();

    public void applyOverlay(NonNullConsumer<ISprite> var1);

    public ISprite copy();

    public ISprite copyWith(ISprite var1);
}

