/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ModBakedModelSupplier {
    private final List<ResourceLocation> _toBeRegistered = Lists.newArrayList();
    private final Map<ResourceLocation, Wrapper> _wrappers = Maps.newHashMap();

    public ModBakedModelSupplier() {
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register((Object)this);
    }

    public void addModel(ResourceLocation name) {
        if (!this._toBeRegistered.contains(name)) {
            this._toBeRegistered.add(name);
        }
    }

    public Supplier<IBakedModel> getOrCreate(ResourceLocation name) {
        return this._wrappers.computeIfAbsent(name, resourceLocation -> new Wrapper());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRegisterModels(ModelRegistryEvent event) {
        this._toBeRegistered.forEach(ModelLoader::addSpecialModel);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        IBakedModel missing = ModRenderHelper.getMissingModel();
        this._wrappers.forEach((key, value) -> ((Wrapper)value)._cachedModel = modelRegistry.getOrDefault(key, missing));
    }

    private static class Wrapper
    implements Supplier<IBakedModel> {
        private IBakedModel _cachedModel = null;

        protected Wrapper() {
        }

        @Override
        public IBakedModel get() {
            return this._cachedModel;
        }
    }
}

