/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnumIndexer<Index extends Enum<Index>> {
    private final List<Index> _validIndices;

    @SafeVarargs
    public EnumIndexer(Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        this(EnumIndexer.join(firstValidIndex, secondValidIndex, otherValidIndices));
    }

    public EnumIndexer(Index validIndex) {
        this._validIndices = ImmutableList.of(validIndex);
    }

    public EnumIndexer(Index[] validIndices) {
        this._validIndices = ImmutableList.copyOf((Object[])validIndices);
    }

    public EnumIndexer(Iterable<Index> validIndices) {
        this._validIndices = ImmutableList.copyOf(validIndices);
    }

    public int getOrdinal(Index index) {
        int ordinal = this._validIndices.indexOf(index);
        if (-1 == ordinal) {
            throw new IllegalArgumentException("Invalid index: " + ((Enum)index).toString());
        }
        return ordinal;
    }

    public Optional<Index> getIndex(int ordinal) {
        if (ordinal < 0 || ordinal > this._validIndices.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this._validIndices.get(ordinal));
    }

    public int validIndicesCount() {
        return this._validIndices.size();
    }

    public List<Index> getValidIndices() {
        return this._validIndices;
    }

    public boolean isIndexValid(Index index) {
        return this.getValidIndices().contains(index);
    }

    public String toString() {
        return this.getValidIndices().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @SafeVarargs
    private static <Index extends Enum<Index>> List<Index> join(Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        ArrayList indices = Lists.newArrayListWithCapacity((int)(2 + otherValidIndices.length));
        indices.add(firstValidIndex);
        indices.add(secondValidIndex);
        if (otherValidIndices.length > 0) {
            indices.addAll(Arrays.asList(otherValidIndices));
        }
        return indices;
    }
}

