/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundNBT;

public class Polygon {
    public static final Polygon EMPTY = new Polygon();
    private static final int MIN_COORDINATES = 3;
    private final int[] _xs;
    private final int[] _ys;
    private final int[] _constants;
    private final int[] _multipliers;
    private final int _pointsCount;
    private Rectangle _bounds;

    public Polygon() {
        this(new int[3], new int[3]);
    }

    public Polygon(int pointCount) {
        this(new int[pointCount], new int[pointCount]);
    }

    public Polygon(int ... points) {
        if (0 != points.length % 2 || points.length < 6) {
            throw new IllegalArgumentException("Not enough coordinates");
        }
        int length = points.length / 2;
        int[] xs = new int[length];
        int[] ys = new int[length];
        int pointsIdx = 0;
        int targetIdx = 0;
        while (pointsIdx < points.length) {
            xs[targetIdx] = points[pointsIdx];
            ys[targetIdx] = points[pointsIdx + 1];
            pointsIdx += 2;
            ++targetIdx;
        }
        this._xs = xs;
        this._ys = ys;
        this._pointsCount = length;
        this._constants = new int[length];
        this._multipliers = new int[length];
        this.computeConstants();
    }

    public Polygon(Polygon other) {
        this(other._xs, other._ys);
    }

    public static Polygon syncDataFrom(CompoundNBT data) {
        if (data.func_74764_b("xs") && data.func_74764_b("ys")) {
            int[] xs = data.func_74759_k("xs");
            int[] ys = data.func_74759_k("ys");
            if (xs.length > 0 && xs.length == ys.length) {
                return new Polygon(xs, ys);
            }
        }
        return EMPTY;
    }

    public CompoundNBT syncDataTo(CompoundNBT data) {
        data.func_74783_a("xs", this._xs);
        data.func_74783_a("ys", this._ys);
        return data;
    }

    public Polygon addPoint(int x, int y) {
        int[] xs = new int[this._pointsCount + 1];
        int[] ys = new int[this._pointsCount + 1];
        System.arraycopy(this._xs, 0, xs, 0, this._pointsCount);
        System.arraycopy(this._ys, 0, ys, 0, this._pointsCount);
        xs[this._pointsCount] = x;
        ys[this._pointsCount] = y;
        return new Polygon(xs, ys);
    }

    public int getX(int vertexIndex) {
        return this._xs[vertexIndex];
    }

    public int getY(int vertexIndex) {
        return this._ys[vertexIndex];
    }

    public int count() {
        return this._pointsCount;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Rectangle getBounds() {
        if (this.isEmpty()) {
            return Rectangle.ZERO;
        }
        if (null == this._bounds) {
            this._bounds = this.computeBounds();
        }
        return this._bounds;
    }

    public Polygon offset(int offsetX, int offsetY) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Polygon polygon = new Polygon(this);
        for (int idx = 0; idx < polygon.count(); ++idx) {
            polygon._xs[idx] = polygon._xs[idx] + offsetX;
            polygon._ys[idx] = polygon._ys[idx] + offsetY;
        }
        return polygon;
    }

    public Polygon offset(int ... offsets) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (offsets.length < this.count() * 2) {
            throw new IllegalArgumentException("Not enough offsets");
        }
        int[] xs = new int[this.count()];
        int[] ys = new int[this.count()];
        int offsetIdx = 0;
        int idx = 0;
        while (idx < this.count()) {
            xs[idx] = this.getX(idx) + offsets[offsetIdx];
            ys[idx] = this.getY(idx) + offsets[offsetIdx + 1];
            ++idx;
            offsetIdx += 2;
        }
        return new Polygon(xs, ys);
    }

    public Polygon transform(IntFunction<Integer> xMapper, IntFunction<Integer> yMapper) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        int[] xs = new int[this.count()];
        int[] ys = new int[this.count()];
        for (int idx = 0; idx < this.count(); ++idx) {
            xs[idx] = xMapper.apply(this.getX(idx));
            ys[idx] = yMapper.apply(this.getY(idx));
        }
        return new Polygon(xs, ys);
    }

    public Polygon transform(BiFunction<Integer, Integer, Point> mapper) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        int[] xs = new int[this.count()];
        int[] ys = new int[this.count()];
        for (int idx = 0; idx < this.count(); ++idx) {
            Point p = mapper.apply(this.getX(idx), this.getY(idx));
            xs[idx] = p.X;
            ys[idx] = p.Y;
        }
        return new Polygon(xs, ys);
    }

    public boolean contains(int x, int y) {
        boolean oddNodes = false;
        boolean current = this._ys[this._pointsCount - 1] > y;
        for (int i = 0; i < this._pointsCount; ++i) {
            boolean previous = current;
            boolean bl = current = this._ys[i] > y;
            if (current == previous) continue;
            oddNodes ^= y * this._multipliers[i] + this._constants[i] < x;
        }
        return oddNodes;
    }

    public boolean equals(Object other) {
        if (other instanceof Polygon) {
            Polygon polygon = (Polygon)other;
            return this._pointsCount == polygon._pointsCount && Arrays.equals(this._xs, polygon._xs) && Arrays.equals(this._ys, polygon._ys);
        }
        return false;
    }

    public String toString() {
        return String.format("Polygon [%d]", this.count());
    }

    private Polygon(int[] xs, int[] ys) {
        if (xs.length <= 0 || xs.length != ys.length) {
            throw new IllegalArgumentException("Invalid coordinates");
        }
        int length = xs.length;
        this._xs = Arrays.copyOf(xs, length);
        this._ys = Arrays.copyOf(ys, length);
        this._pointsCount = length;
        this._constants = new int[length];
        this._multipliers = new int[length];
        this.computeConstants();
    }

    private void computeConstants() {
        int[] xs = this._xs;
        int[] ys = this._ys;
        int j = this._pointsCount - 1;
        int i = 0;
        while (i < this._pointsCount) {
            if (ys[j] == ys[i]) {
                this._constants[i] = xs[i];
                this._multipliers[i] = 0;
            } else {
                this._constants[i] = xs[i] - ys[i] * xs[j] / (ys[j] - ys[i]) + ys[i] * xs[i] / (ys[j] - ys[i]);
                this._multipliers[i] = (xs[j] - xs[i]) / (ys[j] - ys[i]);
            }
            j = i++;
        }
    }

    private Rectangle computeBounds() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int idx = 0; idx < this.count(); ++idx) {
            int x = this.getX(idx);
            int y = this.getY(idx);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }
}

