/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class JSONHelper {
    public static int jsonGetInt(JsonElement json, String elementName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        throw new JsonSyntaxException("JSON element is not a integer: " + elementName);
    }

    public static int jsonGetInt(JsonObject json, String elementName) {
        return JSONHelper.jsonGetInt(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName);
    }

    public static int jsonGetInt(JsonObject json, String elementName, int defaultValue) {
        return json.has(elementName) ? JSONHelper.jsonGetInt(json.get(elementName), elementName) : defaultValue;
    }

    public static void jsonSetInt(JsonObject json, String elementName, int value) {
        json.addProperty(elementName, (Number)value);
    }

    public static long jsonGetLong(JsonElement json, String elementName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsLong();
        }
        throw new JsonSyntaxException("JSON element is not a integer: " + elementName);
    }

    public static long jsonGetLong(JsonObject json, String elementName) {
        return JSONHelper.jsonGetLong(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName);
    }

    public static long jsonGetLong(JsonObject json, String elementName, long defaultValue) {
        return json.has(elementName) ? JSONHelper.jsonGetLong(json.get(elementName), elementName) : defaultValue;
    }

    public static void jsonSetLong(JsonObject json, String elementName, long value) {
        json.addProperty(elementName, (Number)value);
    }

    public static short jsonGetShort(JsonElement json, String elementName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsShort();
        }
        throw new JsonSyntaxException("JSON element is not a integer: " + elementName);
    }

    public static short jsonGetShort(JsonObject json, String elementName) {
        return JSONHelper.jsonGetShort(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName);
    }

    public static short jsonGetShort(JsonObject json, String elementName, short defaultValue) {
        return json.has(elementName) ? JSONHelper.jsonGetShort(json.get(elementName), elementName) : defaultValue;
    }

    public static void jsonSetShort(JsonObject json, String elementName, short value) {
        json.addProperty(elementName, (Number)value);
    }

    public static double jsonGetDouble(JsonElement json, String elementName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        throw new JsonSyntaxException("JSON element is not a double: " + elementName);
    }

    public static double jsonGetDouble(JsonObject json, String elementName) {
        return JSONHelper.jsonGetDouble(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName);
    }

    public static double jsonGetDouble(JsonObject json, String elementName, double defaultValue) {
        return json.has(elementName) ? JSONHelper.jsonGetDouble(json.get(elementName), elementName) : defaultValue;
    }

    public static void jsonSetDouble(JsonObject json, String elementName, double value) {
        json.addProperty(elementName, (Number)value);
    }

    public static String jsonGetString(JsonElement json, String elementName) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        throw new JsonSyntaxException("JSON element is not a string: " + elementName);
    }

    public static String jsonGetString(JsonObject json, String elementName) {
        return JSONHelper.jsonGetString(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName);
    }

    public static String jsonGetString(JsonObject json, String elementName, String defaultValue) {
        return json.has(elementName) ? JSONHelper.jsonGetString(json.get(elementName), elementName) : defaultValue;
    }

    public static void jsonSetString(JsonObject json, String elementName, String value) {
        json.addProperty(elementName, value);
    }

    public static <T extends Enum<T>> T jsonGetEnum(JsonObject json, String elementName, Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[JSONHelper.jsonGetInt(json, elementName)];
    }

    public static void jsonSetEnum(JsonObject json, String elementName, Enum<?> value) {
        JSONHelper.jsonSetInt(json, elementName, value.ordinal());
    }

    public static ResourceLocation jsonGetResourceLocation(JsonObject json, String elementName) {
        return new ResourceLocation(JSONHelper.jsonGetString(JSONHelper.jsonGetMandatoryElement(json, elementName), elementName));
    }

    public static void jsonSetResourceLocation(JsonObject json, String elementName, ResourceLocation value) {
        JSONHelper.jsonSetString(json, elementName, value.toString());
    }

    public static CompoundNBT jsonGetNBT(JsonObject json, String elementName) {
        try {
            return JsonToNBT.func_180713_a((String)JSONHelper.jsonGetString(json, elementName));
        }
        catch (CommandSyntaxException ex) {
            throw new JsonSyntaxException("JSON element is not a valid CompoundNBT tag: " + elementName);
        }
    }

    public static CompoundNBT jsonGetNBT(JsonObject json, String elementName, CompoundNBT defaultValue) {
        try {
            return json.has(elementName) ? JsonToNBT.func_180713_a((String)JSONHelper.jsonGetString(json.get(elementName), elementName)) : defaultValue;
        }
        catch (CommandSyntaxException ex) {
            throw new JsonSyntaxException("JSON element is not a valid CompoundNBT tag: " + elementName);
        }
    }

    public static void jsonSetNBT(JsonObject json, String elementName, CompoundNBT value) {
        JSONHelper.jsonSetString(json, elementName, value.toString());
    }

    public static Item jsonGetItem(JsonObject json, String elementName) {
        ResourceLocation id = JSONHelper.jsonGetResourceLocation(json, elementName);
        if (ForgeRegistries.ITEMS.containsKey(id)) {
            return (Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(id));
        }
        throw new JsonSyntaxException("JSON element is not a valid Item: " + elementName);
    }

    public static void jsonSetItem(JsonObject json, String elementName, IItemProvider value) {
        JSONHelper.jsonSetResourceLocation(json, elementName, ItemHelper.getItemId(value));
    }

    public static Fluid jsonGetFluid(JsonObject json, String elementName) {
        ResourceLocation id = JSONHelper.jsonGetResourceLocation(json, elementName);
        if (ForgeRegistries.FLUIDS.containsKey(id)) {
            return (Fluid)Objects.requireNonNull(ForgeRegistries.FLUIDS.getValue(id));
        }
        throw new JsonSyntaxException("JSON element is not a valid Fluid: " + elementName);
    }

    public static void jsonSetFluid(JsonObject json, String elementName, Fluid value) {
        JSONHelper.jsonSetResourceLocation(json, elementName, FluidHelper.getFluidId(value));
    }

    public static Ingredient jsonGetIngredient(JsonObject json, String elementName) {
        return Ingredient.func_199802_a((JsonElement)JSONHelper.jsonGetMandatoryElement(json, elementName));
    }

    public static void jsonSetIngredient(JsonObject json, String elementName, Ingredient value) {
        json.add(elementName, value.func_200304_c());
    }

    public static JsonElement jsonGetMandatoryElement(JsonObject json, String elementName) {
        if (json.has(elementName)) {
            return json.get(elementName);
        }
        throw new JsonSyntaxException("Missing required element in JSON object " + elementName);
    }

    private JSONHelper() {
    }
}

