/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterManager;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterComponentFactory;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterCondition;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class ItemStackFilterCondition
implements IFilterCondition {
    private ItemStack _filterStack;
    private static final String NBT_KEY = "CndStack";
    private static final ResourceLocation COMPONENT_ID = ZeroCore.newID("inventory.filter.ItemStackFilterCondition");

    public ItemStackFilterCondition(ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"The stack must not be null");
        this.setFilterStack(stack);
    }

    @Nullable
    public ItemStack getFilterStack() {
        return this._filterStack;
    }

    public void setFilterStack(ItemStack filterStack) {
        this._filterStack = ItemHelper.stackFrom(filterStack);
    }

    public void setFilterStack(ItemStack filterStack, int amount) {
        this._filterStack = ItemHelper.stackFrom(filterStack, amount);
    }

    public boolean isValid() {
        return null != this.getFilterStack();
    }

    @Override
    public ResourceLocation getComponentId() {
        return COMPONENT_ID;
    }

    @Override
    public boolean match(ItemStack stack, EnumSet<ItemHelper.MatchOption> matchOptions) {
        Preconditions.checkNotNull(matchOptions, (Object)"The match options must not be null");
        return ItemHelper.stackMatch(this._filterStack, stack, matchOptions);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (null != this._filterStack) {
            nbt.func_218657_a(NBT_KEY, (INBT)this._filterStack.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this._filterStack = null == nbt || !nbt.func_74764_b(NBT_KEY) ? null : ItemHelper.stackFrom(nbt.func_74775_l(NBT_KEY));
    }

    private ItemStackFilterCondition() {
        this._filterStack = null;
    }

    static {
        FilterManager<ItemStackFilterCondition> fm = FilterManager.getInstance();
        fm.registerFactory(COMPONENT_ID, new IFilterComponentFactory<ItemStackFilterCondition>(){

            @Override
            public Optional<ItemStackFilterCondition> createComponent(ResourceLocation componentId) {
                return Optional.of(new ItemStackFilterCondition());
            }

            @Override
            public Optional<ItemStackFilterCondition> createComponent(ResourceLocation componentId, CompoundNBT nbt) {
                return this.createComponent(componentId).map(condition -> {
                    condition.deserializeNBT(nbt);
                    return condition.isValid() ? condition : null;
                });
            }
        });
    }
}

