/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.cuboid;

import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.Optional;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;

public enum PartPosition implements IStringSerializable
{
    Unknown(null, Type.Unknown),
    Interior(null, Type.Unknown),
    FrameCorner(null, Type.Frame),
    FrameEastWest(null, Type.Frame),
    FrameSouthNorth(null, Type.Frame),
    FrameUpDown(null, Type.Frame),
    TopFace(Direction.UP, Type.Face),
    BottomFace(Direction.DOWN, Type.Face),
    NorthFace(Direction.NORTH, Type.Face),
    SouthFace(Direction.SOUTH, Type.Face),
    EastFace(Direction.EAST, Type.Face),
    WestFace(Direction.WEST, Type.Face);

    private final Direction _facing;
    private final Type _type;

    @Deprecated
    public static <Controller extends AbstractCuboidMultiblockController<Controller>> PartPosition positionIn(Controller controller, BlockPos blockPosition) {
        CuboidBoundingBox bb = controller.getBoundingBox();
        BlockPos minimumCoord = bb.getMin();
        BlockPos maximumCoord = bb.getMax();
        boolean downFacing = blockPosition.func_177956_o() == minimumCoord.func_177956_o();
        boolean upFacing = blockPosition.func_177956_o() == maximumCoord.func_177956_o();
        boolean northFacing = blockPosition.func_177952_p() == minimumCoord.func_177952_p();
        boolean southFacing = blockPosition.func_177952_p() == maximumCoord.func_177952_p();
        boolean westFacing = blockPosition.func_177958_n() == minimumCoord.func_177958_n();
        boolean eastFacing = blockPosition.func_177958_n() == maximumCoord.func_177958_n();
        int facesMatching = 0;
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        PartPosition position = facesMatching <= 0 ? Interior : (facesMatching >= 3 ? FrameCorner : (facesMatching == 2 ? (!eastFacing && !westFacing ? FrameEastWest : (!southFacing && !northFacing ? FrameSouthNorth : FrameUpDown)) : (eastFacing ? EastFace : (westFacing ? WestFace : (southFacing ? SouthFace : (northFacing ? NorthFace : (upFacing ? TopFace : BottomFace)))))));
        return position;
    }

    public static PartPosition positionIn(BlockPos boundingBoxMin, BlockPos boundingBoxMax, BlockPos blockPosition) {
        boolean downFacing = blockPosition.func_177956_o() == boundingBoxMin.func_177956_o();
        boolean upFacing = blockPosition.func_177956_o() == boundingBoxMax.func_177956_o();
        boolean northFacing = blockPosition.func_177952_p() == boundingBoxMin.func_177952_p();
        boolean southFacing = blockPosition.func_177952_p() == boundingBoxMax.func_177952_p();
        boolean westFacing = blockPosition.func_177958_n() == boundingBoxMin.func_177958_n();
        boolean eastFacing = blockPosition.func_177958_n() == boundingBoxMax.func_177958_n();
        int facesMatching = 0;
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        PartPosition position = facesMatching <= 0 ? Interior : (facesMatching >= 3 ? FrameCorner : (facesMatching == 2 ? (!eastFacing && !westFacing ? FrameEastWest : (!southFacing && !northFacing ? FrameSouthNorth : FrameUpDown)) : (eastFacing ? EastFace : (westFacing ? WestFace : (southFacing ? SouthFace : (northFacing ? NorthFace : (upFacing ? TopFace : BottomFace)))))));
        return position;
    }

    public boolean isFace() {
        return this._type == Type.Face;
    }

    public boolean isVerticalFace() {
        return EastFace == this || WestFace == this || NorthFace == this || SouthFace == this;
    }

    public boolean isHorizontalFace() {
        return TopFace == this || BottomFace == this;
    }

    public boolean isFrame() {
        return this._type == Type.Frame;
    }

    public Optional<Direction> getDirection() {
        return Optional.ofNullable(this._facing);
    }

    public Type getType() {
        return this._type;
    }

    public static EnumProperty<PartPosition> createProperty(String name) {
        return EnumProperty.func_177709_a((String)name, PartPosition.class);
    }

    public String func_176610_l() {
        return this.toString();
    }

    private PartPosition(Direction facing, Type type) {
        this._facing = facing;
        this._type = type;
    }

    public static enum Type {
        Unknown,
        Interior,
        Frame,
        Face;

    }
}

