/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.AbstractFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidPortHandlerForge<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller> & IIoEntity>
extends AbstractFluidPortHandler<Controller, V, T>
implements IFluidHandler {
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> CAPAP_FORGE_FLUIDHANDLER = null;
    private IFluidHandler _consumer = null;
    private final FluidHandlerForwarder _capabilityForwarder;
    private final LazyOptional<IFluidHandler> _capability = LazyOptional.of(() -> this);

    public FluidPortHandlerForge(T part, IoMode mode) {
        super(FluidPortType.Forge, part, mode);
        this._capabilityForwarder = new FluidHandlerForwarder((IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    @Override
    public int outputFluid(FluidStack stack) {
        if (null == this._consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isInput()) {
            return 0;
        }
        return this._consumer.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public int inputFluid(IFluidHandler destination, int maxAmount) {
        if (null == this._consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isOutput()) {
            return 0;
        }
        FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)this._consumer, (int)maxAmount, (boolean)true);
        return transferred.isEmpty() ? 0 : transferred.getAmount();
    }

    @Override
    public boolean isConnected() {
        return null != this._consumer;
    }

    @Override
    public void checkConnections(@Nullable IWorldReader world, BlockPos position) {
        this._consumer = this.lookupConsumer(world, position, CAPAP_FORGE_FLUIDHANDLER, (NonNullPredicate<TileEntity>)((NonNullPredicate)te -> te instanceof IFluidPortHandler), this._consumer);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (CAPAP_FORGE_FLUIDHANDLER == capability) {
            return this._capability.cast();
        }
        return null;
    }

    @Override
    public void invalidate() {
        this._capability.invalidate();
    }

    @Override
    public void update() {
        this.updateCapabilityForwarder();
    }

    public int getTanks() {
        return this._capabilityForwarder.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this._capabilityForwarder.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this._capabilityForwarder.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this._capabilityForwarder.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.fill(resource, action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(resource, action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(maxDrain, action) : FluidStack.EMPTY;
    }

    private void updateCapabilityForwarder() {
        this._capabilityForwarder.setHandler((IFluidHandler)this.getPart().evalOnController(c -> c.getFluidHandler(((IIoEntity)this.getIoEntity()).getIoDirection()).orElse((IFluidHandler)EmptyFluidHandler.INSTANCE), (Object)EmptyFluidHandler.INSTANCE));
    }
}

