/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.FluidMappingsRegistry;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.AbstractFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.api.recipes.RotaryRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidPortHandlerMekanism<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller> & IIoEntity>
extends AbstractFluidPortHandler<Controller, V, T>
implements IGasHandler {
    @CapabilityInject(value=IGasHandler.class)
    public static Capability<IGasHandler> CAPAP_MEKANISM_GASHANDLER = null;
    private static Map<Fluid, IMapping<Fluid, Gas>> s_fluidToGas;
    private static Map<Gas, IMapping<Gas, Fluid>> s_gasToFluid;
    private IGasHandler _consumer = null;
    private final FluidHandlerForwarder _capabilityForwarder;
    private final LazyOptional<IGasHandler> _capability = LazyOptional.of(() -> this);

    public FluidPortHandlerMekanism(T part, IoMode mode) {
        super(FluidPortType.Mekanism, part, IoMode.Passive);
        this._capabilityForwarder = new FluidHandlerForwarder((IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    @Override
    public int outputFluid(FluidStack stack) {
        if (null == this._consumer || this.isPassive()) {
            return 0;
        }
        return (int)((GasStack)this._consumer.insertChemical((ChemicalStack)FluidPortHandlerMekanism.getGasStack(stack), Action.EXECUTE)).getAmount();
    }

    @Override
    public int inputFluid(IFluidHandler destination, int maxAmount) {
        return 0;
    }

    @Override
    public boolean isConnected() {
        return null != this._consumer;
    }

    @Override
    public void checkConnections(@Nullable IWorldReader world, BlockPos position) {
        this._consumer = this.lookupConsumer(world, position, CAPAP_MEKANISM_GASHANDLER, (NonNullPredicate<TileEntity>)((NonNullPredicate)te -> te instanceof IFluidPortHandler), this._consumer);
    }

    @Override
    public void invalidate() {
        this._capability.invalidate();
    }

    @Override
    public void update() {
        this.updateCapabilityForwarder();
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (CAPAP_MEKANISM_GASHANDLER == capability) {
            return this._capability.cast();
        }
        return null;
    }

    public int getTanks() {
        return 1;
    }

    public GasStack getChemicalInTank(int idx) {
        return 0 != idx ? GasStack.EMPTY : FluidPortHandlerMekanism.getGasStack(this._capabilityForwarder.getFluidInTank(0));
    }

    public void setChemicalInTank(int idx, GasStack stack) {
    }

    public long getTankCapacity(int idx) {
        return 0 == idx ? (long)this._capabilityForwarder.getTankCapacity(0) : 0L;
    }

    public boolean isValid(int idx, GasStack stack) {
        return false;
    }

    public GasStack insertChemical(int idx, GasStack stack, Action action) {
        return stack;
    }

    public GasStack extractChemical(int idx, long amount, Action action) {
        FluidStack currentStack = this._capabilityForwarder.getFluidInTank(0);
        if (0 != idx || currentStack.isEmpty()) {
            return GasStack.EMPTY;
        }
        IMapping<Fluid, Gas> fluidMapping = FluidPortHandlerMekanism.getFluidMapping(currentStack.getFluid());
        if (null == fluidMapping) {
            return GasStack.EMPTY;
        }
        IMapping<Gas, Fluid> gasMapping = FluidPortHandlerMekanism.getGasMapping(fluidMapping.getProduct());
        if (null == gasMapping) {
            return GasStack.EMPTY;
        }
        int amountToRemove = gasMapping.getProductAmount((int)Math.max(amount, Integer.MAX_VALUE));
        FluidStack removed = this._capabilityForwarder.drain(amountToRemove, action.toFluidAction());
        return FluidPortHandlerMekanism.getGasStack(removed);
    }

    private void updateCapabilityForwarder() {
        this._capabilityForwarder.setHandler((IFluidHandler)this.getPart().evalOnController(c -> c.getFluidHandler(IoDirection.Output).orElse((IFluidHandler)EmptyFluidHandler.INSTANCE), (Object)EmptyFluidHandler.INSTANCE));
    }

    private static GasStack getGasStack(FluidStack fluidStack) {
        return fluidStack.isEmpty() ? GasStack.EMPTY : FluidPortHandlerMekanism.getGasStack(fluidStack.getFluid(), fluidStack.getAmount());
    }

    private static GasStack getGasStack(Fluid fluid, int amount) {
        IMapping<Fluid, Gas> mapping = FluidPortHandlerMekanism.getFluidMapping(fluid);
        return null != mapping ? new GasStack((IGasProvider)mapping.getProduct(), (long)mapping.getProductAmount(amount)) : GasStack.EMPTY;
    }

    @Nullable
    private static IMapping<Fluid, Gas> getFluidMapping(Fluid fluid) {
        if (null == s_fluidToGas) {
            FluidPortHandlerMekanism.buildMappings();
        }
        return s_fluidToGas.get(fluid);
    }

    @Nullable
    private static IMapping<Gas, Fluid> getGasMapping(Gas gas) {
        if (null == s_gasToFluid) {
            FluidPortHandlerMekanism.buildMappings();
        }
        return s_gasToFluid.get(gas);
    }

    private static void buildMappings() {
        s_fluidToGas = new Object2ObjectOpenHashMap(8);
        s_gasToFluid = new Object2ObjectOpenHashMap(8);
        CodeHelper.getMinecraftServer().ifPresent(server -> {
            ResourceLocation typeId = new ResourceLocation(Mods.MEKANISM.id(), "rotary");
            IRecipeType type = (IRecipeType)Registry.field_218367_H.func_82594_a(typeId);
            if (null != type) {
                server.func_199529_aN().func_241447_a_(type).stream().filter(RotaryRecipe::hasFluidToGas).forEach(rotaryRecipe -> {
                    GasStack gasStack = rotaryRecipe.getGasOutputRepresentation();
                    rotaryRecipe.getFluidInput().getRepresentations().stream().filter(FluidMappingsRegistry::hasVaporFrom).forEach(fluidStack -> {
                        IMapping<Fluid, Chemical> mapping = IMapping.of(fluidStack.getFluid(), fluidStack.getAmount(), gasStack.getRaw(), (int)gasStack.getAmount());
                        s_fluidToGas.put(fluidStack.getFluid(), mapping);
                        s_gasToFluid.put((Gas)mapping.getProduct(), mapping.getReverse());
                    });
                });
            }
        });
    }
}

