/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.zerocore.lib.client.model.data.AbstractModelDataMap;
import it.zerono.mods.zerocore.lib.client.model.data.NamedModelProperty;
import java.util.Objects;
import net.minecraftforge.client.model.data.ModelProperty;

public class ReactorFuelRodModelData
extends AbstractModelDataMap {
    public static final ModelProperty<Short> REACTANTS_MODEL_KEY = new NamedModelProperty("REACTANTS_MODEL_KEY", Objects::nonNull);
    public static final ModelProperty<Boolean> VERTICAL = new NamedModelProperty("VERTICAL", Objects::nonNull);
    public static final ModelProperty<Boolean> OCCLUDED = new NamedModelProperty("OCCLUDED", Objects::nonNull);
    public static final ModelProperty<Byte> FUEL_LEVEL = new NamedModelProperty("FUEL_LEVEL", Objects::nonNull);
    public static final ModelProperty<Byte> WASTE_LEVEL = new NamedModelProperty("WASTE_LEVEL", Objects::nonNull);
    private static final Short2ObjectMap<ReactorFuelRodModelData> s_cache = new Short2ObjectArrayMap(512);

    public static ReactorFuelRodModelData from(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return (ReactorFuelRodModelData)((Object)s_cache.computeIfAbsent(ReactorFuelRodModelData.createKey(fuelData, rodIsOccluded), k -> new ReactorFuelRodModelData(k, fuelData, rodIsOccluded)));
    }

    public short getModelKey() {
        Short v = (Short)this.getData(REACTANTS_MODEL_KEY);
        return null != v ? v : (short)0;
    }

    public boolean isVertical() {
        Boolean v = (Boolean)this.getData(VERTICAL);
        return null != v && v != false;
    }

    public boolean isOccluded() {
        Boolean v = (Boolean)this.getData(OCCLUDED);
        return null != v && v != false;
    }

    public byte getFuelLevel() {
        Byte v = (Byte)this.getData(FUEL_LEVEL);
        return null != v ? v : (byte)0;
    }

    public byte getWasteLevel() {
        Byte v = (Byte)this.getData(WASTE_LEVEL);
        return null != v ? v : (byte)0;
    }

    private ReactorFuelRodModelData(int dataKey, ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        super(5);
        this.addProperty(REACTANTS_MODEL_KEY, (short)(dataKey & 0xFF));
        this.addProperty(VERTICAL, fuelData.isVertical());
        this.addProperty(OCCLUDED, rodIsOccluded);
        this.addProperty(FUEL_LEVEL, fuelData.getFuelLevel());
        this.addProperty(WASTE_LEVEL, fuelData.getWasteLevel());
    }

    private static short createKey(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return (short)((fuelData.isVertical() ? 32768 : 0) | (rodIsOccluded ? 16384 : 0) | fuelData.getFuelLevel() << 4 | fuelData.getWasteLevel() & 0xF);
    }
}

