/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorSolidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorSolidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class ReactorSolidAccessPortScreen
extends AbstractMultiblockScreen<MultiblockReactor, ReactorSolidAccessPortEntity, ReactorSolidAccessPortContainer> {
    private final BindingGroup _bindings = new BindingGroup();
    private final SwitchPictureButton _btnInputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionInput", false, "direction");
    private final SwitchPictureButton _btnOutputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionOutput", false, "direction");
    private final Button _btnDumpFuel = new Button((ModContainerScreen)this, "dumpFuel", "");
    private final Button _btnDumpWaste = new Button((ModContainerScreen)this, "dumpWaste", "");

    public ReactorSolidAccessPortScreen(ReactorSolidAccessPortContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, PlayerInventoryUsage.Both, title, ReactorSolidAccessPortScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorSolidAccessPortEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
    }

    @Override
    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("reactor/part-solidaccessport"), 1);
        super.onScreenCreate();
        Panel panel = new Panel((ModContainerScreen)this, "solidaccessport");
        panel.setLayoutEngineHint(FixedLayoutEngine.hint((int)21, (int)13, (int)168, (int)38));
        this.addControl((IControl)panel);
        panel.addControl((IControl)this.slotPanel("fuelinput", ReactantType.Fuel, 79, 0, CommonIcons.PortInputSlot));
        panel.addControl((IControl)this.slotPanel("wasteoutput", ReactantType.Waste, 129, 0, CommonIcons.PortOutputSlot));
        SlotsGroup slotsGroup = this.createPlayerInventorySlotsGroupControl();
        slotsGroup.setLayoutEngineHint(FixedLayoutEngine.hint((int)31, (int)63));
        this.addControl((IControl)slotsGroup);
        slotsGroup = this.createPlayerHotBarSlotsGroupControl();
        slotsGroup.setLayoutEngineHint(FixedLayoutEngine.hint((int)31, (int)121));
        this.addControl((IControl)slotsGroup);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnInputDirection, ButtonState.Default, CommonIcons.ButtonInputDirection);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnInputDirection, ButtonState.Active, CommonIcons.ButtonInputDirectionActive);
        this._btnInputDirection.Activated.subscribe(this::onInputActivated);
        this._btnInputDirection.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.directioninput.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.directioninput.line2")});
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnOutputDirection, ButtonState.Default, CommonIcons.ButtonOutputDirection);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnOutputDirection, ButtonState.Active, CommonIcons.ButtonOutputDirectionActive);
        this._btnOutputDirection.Activated.subscribe(this::onOutputActivated);
        this._btnOutputDirection.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.directionoutput.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.directionoutput.line2")});
        this.addBinding(ReactorSolidAccessPortContainer::getIoDirection, value -> {
            this._btnInputDirection.setActive(value.isInput());
            this._btnOutputDirection.setActive(value.isOutput());
        });
        this._btnDumpFuel.setPadding(0);
        this._btnDumpFuel.setIconForState(CommonIcons.ButtonDumpFuel.get(), ButtonState.Default);
        this._btnDumpFuel.setIconForState(CommonIcons.ButtonDumpFuelActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        this._btnDumpFuel.Clicked.subscribe(this::onDumpFuel);
        this._btnDumpFuel.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpfuel.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpfuel.line2"), new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpfuel.line3"), new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpfuel.line4")});
        this._btnDumpWaste.setPadding(0);
        this._btnDumpWaste.setIconForState(CommonIcons.ButtonDumpWaste.get(), ButtonState.Default);
        this._btnDumpWaste.setIconForState(CommonIcons.ButtonDumpWasteActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        this._btnDumpWaste.Clicked.subscribe(this::onDumpWaste);
        this._btnDumpWaste.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpwaste.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpwaste.line2"), new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpwaste.line3"), new TranslationTextComponent("gui.bigreactors.reactor.solidaccessport.dumpwaste.line4")});
        panel.addControl((IControl)this.buttonsPanel((IControl)this._btnInputDirection, (IControl)this._btnOutputDirection, (IControl)this._btnDumpFuel, (IControl)this._btnDumpWaste));
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    private void onInputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_INPUT);
    }

    private void onOutputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_OUTPUT);
    }

    private void onDumpFuel(Button button, Integer mouseButton) {
        CompoundNBT options = new CompoundNBT();
        options.func_74757_a("void", Screen.func_231173_s_());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_FUEL, options);
    }

    private void onDumpWaste(Button button, Integer integer) {
        CompoundNBT options = new CompoundNBT();
        options.func_74757_a("void", Screen.func_231173_s_());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_WASTE, options);
    }

    private <Value> void addBinding(Function<ReactorSolidAccessPortContainer, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)this.func_212873_a_(), supplier, consumer));
    }

    private Panel buttonsPanel(IControl setInput, IControl setOutput, IControl dumpFuel, IControl dumpWaste) {
        Panel p = new Panel((ModContainerScreen)this);
        p.setLayoutEngineHint(FixedLayoutEngine.hint((int)15, (int)0, (int)38, (int)38));
        p.setCustomBackgroundPainter((panel, matrix) -> {
            Point xy = panel.controlToScreen(0, 0);
            ISprite border = CommonIcons.ImageButtonBorder.get();
            int z = (int)panel.getGui().getZLevel();
            ModRenderHelper.paintSprite((MatrixStack)matrix, (ISprite)border, (int)xy.X, (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((MatrixStack)matrix, (ISprite)border, (int)(xy.X + 20), (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((MatrixStack)matrix, (ISprite)border, (int)xy.X, (int)(xy.Y + 20), (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((MatrixStack)matrix, (ISprite)border, (int)(xy.X + 20), (int)(xy.Y + 20), (int)z, (int)18, (int)18);
        });
        setInput.setLayoutEngineHint(FixedLayoutEngine.hint((int)1, (int)1, (int)16, (int)16));
        p.addControl(setInput);
        setOutput.setLayoutEngineHint(FixedLayoutEngine.hint((int)21, (int)1, (int)16, (int)16));
        p.addControl(setOutput);
        dumpFuel.setLayoutEngineHint(FixedLayoutEngine.hint((int)1, (int)21, (int)16, (int)16));
        p.addControl(dumpFuel);
        dumpWaste.setLayoutEngineHint(FixedLayoutEngine.hint((int)21, (int)21, (int)16, (int)16));
        p.addControl(dumpWaste);
        return p;
    }

    private Panel slotPanel(String groupName, ReactantType reactant, int x, int y, NonNullSupplier<ISprite> slotBackground) {
        SlotsGroup sg = this.createSingleSlotGroupControl(groupName, reactant.name());
        Panel p = new Panel((ModContainerScreen)this);
        sg.setLayoutEngineHint(FixedLayoutEngine.hint((int)10, (int)10, (int)18, (int)18));
        p.setBackground((ISprite)slotBackground.get());
        p.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)y, (int)38, (int)38));
        p.addControl((IControl)sg);
        return p;
    }
}

