/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class TurbineControllerEntity
extends AbstractTurbineEntity
implements INamedContainerProvider,
INetworkTileEntitySyncProvider {
    public static String COMMAND_ENGAGE_COILS = "coilon";
    public static String COMMAND_DISENGAGE_COILS = "coiloff";
    public static String COMMAND_SET_INTAKERATE = "rate";
    public static String COMMAND_SET_VENT = "vent";
    public static String COMMAND_SCRAM = "scram";

    public TurbineControllerEntity() {
        super((TileEntityType)Content.TileEntityTypes.TURBINE_CONTROLLER.get());
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, tce -> tce.setTurbineActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, tce -> tce.setTurbineActive(false)).addServerHandler(COMMAND_ENGAGE_COILS, tce -> tce.executeOnController(tc -> tc.setInductorEngaged(true))).addServerHandler(COMMAND_DISENGAGE_COILS, tce -> tce.executeOnController(tc -> tc.setInductorEngaged(false))).addServerHandler(COMMAND_SET_INTAKERATE, TurbineControllerEntity::setIntakeRate).addServerHandler(COMMAND_SET_VENT, TurbineControllerEntity::setVent).addServerHandler(COMMAND_SCRAM, TurbineControllerEntity::scram).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isTurbineActive() ? 1 : 2) : 0);
    }

    @Override
    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getMultiblockController().ifPresent(reactor -> reactor.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayerEntity player, boolean updateNow) {
        this.getMultiblockController().ifPresent(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayerEntity player) {
        this.getMultiblockController().ifPresent(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.TURBINE_CONTROLLER.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayerEntity)((ServerPlayerEntity)player));
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    private void setIntakeRate(CompoundNBT data) {
        this.executeOnController(turbine -> turbine.setMaxIntakeRate(data.func_74762_e("rate")));
    }

    private void setVent(CompoundNBT data) {
        VentSetting setting = (VentSetting)NBTHelper.nbtGetEnum((CompoundNBT)data, (String)"vent", VentSetting::valueOf, (Enum)VentSetting.getDefault());
        this.executeOnController(turbine -> turbine.setVentSetting(setting));
    }

    private void scram() {
        this.setTurbineActive(false);
    }
}

