/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlizzModel<T extends Entity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer[] cubes;
    private final ImmutableList<ModelRenderer> partsList;

    public BlizzModel() {
        int i;
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_228303_a_(-4.5f, -4.0f, -4.0f, 9.0f, 8.0f, 8.0f, 0.0f, false);
        this.head.func_78784_a(34, 10).func_228303_a_(-4.5f, -4.0f, -6.0f, 9.0f, 4.0f, 2.0f, 0.0f, false);
        this.cubes = new ModelRenderer[12];
        for (i = 0; i < 4; ++i) {
            this.cubes[i] = new ModelRenderer((Model)this, 16 * (i % 4), 24);
            this.cubes[i].func_228300_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f);
        }
        for (i = 4; i < 8; ++i) {
            this.cubes[i] = new ModelRenderer((Model)this, 16 * (i % 4), 16);
            this.cubes[i].func_228300_a_(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f);
        }
        for (i = 8; i < this.cubes.length; ++i) {
            this.cubes[i] = new ModelRenderer((Model)this, 16 * (i % 4), 24);
            this.cubes[i].func_228300_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.head);
        builder.addAll(Arrays.asList(this.cubes));
        this.partsList = builder.build();
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.partsList;
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks * (float)Math.PI * -0.1f;
        for (int i = 0; i < 4; ++i) {
            this.cubes[i].field_78797_d = -2.0f + MathHelper.func_76134_b((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.cubes[i].field_78800_c = MathHelper.func_76134_b((float)f) * 13.0f;
            this.cubes[i].field_78798_e = MathHelper.func_76126_a((float)f) * 13.0f;
            f += 1.0f;
        }
        f = 0.7853982f + ageInTicks * (float)Math.PI * 0.03f;
        for (int j = 4; j < 8; ++j) {
            this.cubes[j].field_78797_d = 5.0f + MathHelper.func_76134_b((float)(((float)(j * 2) + ageInTicks) * 0.25f));
            this.cubes[j].field_78800_c = MathHelper.func_76134_b((float)f) * 9.0f;
            this.cubes[j].field_78798_e = MathHelper.func_76126_a((float)f) * 9.0f;
            f += 1.0f;
        }
        f = 0.47123894f + ageInTicks * (float)Math.PI * -0.05f;
        for (int k = 8; k < 12; ++k) {
            this.cubes[k].field_78797_d = 12.0f + MathHelper.func_76134_b((float)(((float)k * 1.5f + ageInTicks) * 0.5f));
            this.cubes[k].field_78800_c = MathHelper.func_76134_b((float)f) * 5.0f;
            this.cubes[k].field_78798_e = MathHelper.func_76126_a((float)f) * 5.0f;
            f += 1.0f;
        }
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
    }
}

