/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.patchouli;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CraftingProcessor
implements IComponentProcessor {
    private ICraftingRecipe recipe;

    public void setup(IVariableProvider variables) {
        if (!variables.has("recipe")) {
            return;
        }
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        Optional recipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(recipeId);
        if (recipe.isPresent() && recipe.get() instanceof ICraftingRecipe) {
            this.recipe = (ICraftingRecipe)recipe.get();
        } else {
            LogManager.getLogger().warn("Thermalpedia missing the crafting recipe: " + recipeId);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("out")) {
            return IVariable.from((Object)this.recipe.func_77571_b());
        }
        if (key.startsWith("in")) {
            int width;
            int index = Integer.parseInt(key.substring(key.length() - 1));
            if (this.recipe instanceof ShapedRecipe && (width = ((ShapedRecipe)this.recipe).getRecipeWidth()) < 3) {
                if (index % 3 >= width) {
                    return null;
                }
                index = index * width / 3 + index % 3;
            }
            if (this.recipe.func_192400_c().size() <= index) {
                return null;
            }
            return IVariable.wrapList((Iterable)Arrays.stream(((Ingredient)this.recipe.func_192400_c().get(index)).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("title")) {
            return IVariable.from((Object)this.recipe.func_77571_b().func_200301_q());
        }
        if (key.equals("show")) {
            return IVariable.wrap((Boolean)true);
        }
        return null;
    }
}

