/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.thermal.core.util.recipes.machine.CrafterRecipe;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IManager;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class CrafterRecipeManager
extends AbstractManager
implements IManager {
    private static final CrafterRecipeManager INSTANCE = new CrafterRecipeManager();
    protected static final int DEFAULT_ENERGY = 400;
    protected IdentityHashMap<IRecipe<?>, CrafterRecipe> recipeMap = new IdentityHashMap();

    public static CrafterRecipeManager instance() {
        return INSTANCE;
    }

    private CrafterRecipeManager() {
        super(400);
    }

    public boolean validItem(ItemStack item, IMachineRecipe recipe) {
        return recipe instanceof CrafterRecipe && ((CrafterRecipe)recipe).validItem(item);
    }

    public boolean validFluid(FluidStack fluid, IMachineRecipe recipe) {
        return recipe instanceof CrafterRecipe && ((CrafterRecipe)recipe).validFluid(fluid);
    }

    public CrafterRecipe getRecipe(IRecipe<?> recipe) {
        if (recipe == null || recipe.func_192399_d() || recipe.func_77571_b().func_190926_b()) {
            return null;
        }
        if (!this.recipeMap.containsKey(recipe)) {
            this.recipeMap.put(recipe, new CrafterRecipe(400, recipe));
        }
        return this.recipeMap.get(recipe);
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.recipeMap.clear();
    }
}

