/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiConfigControl
extends GuiParent {
    public final ConfigKey.ConfigKeyField field;
    public final Dist side;
    private GuiButton resetButton;
    protected int initalWidth;
    protected int initalHeight;

    public GuiConfigControl(ConfigKey.ConfigKeyField field, int x, int y, int width, int height, Dist side) {
        super(field.name, x, y, width, height);
        this.field = field;
        this.side = side;
        this.initalWidth = width;
        this.initalHeight = height;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void setResetButton(GuiButton resetButton) {
        this.resetButton = resetButton;
        this.updateButton();
    }

    public void updateButton() {
        this.resetButton.enabled = !this.field.isDefault(this.field.converation.save(this, this.field.getType(), this.field), this.side);
    }

    public void init(JsonElement initalValue) {
        this.field.converation.createControls(this, this.field, this.field.getType(), this.getWidth() - 20);
        this.field.converation.loadValue(initalValue != null ? this.field.converation.readElement(this.field.getDefault(), false, false, initalValue, this.side, this.field) : this.field.get(), this, this.field);
    }

    public void reset() {
        this.field.converation.loadValue(this.field.getDefault(), this, this.field);
        this.updateButton();
    }

    public void changed() {
        this.updateButton();
    }

    public JsonElement save() {
        Object value = this.field.converation.save(this, this.field.getType(), this.field);
        if (!this.field.get().equals(value)) {
            return this.field.converation.writeElement(value, this.field.getDefault(), true, false, this.side, this.field);
        }
        return null;
    }

    @Override
    public void setWidthLayout(int width) {
        this.setWidth(width);
    }

    @Override
    public int getMinWidth() {
        return 20;
    }

    @Override
    public int getPreferredWidth() {
        return this.initalWidth;
    }

    @Override
    public void setHeightLayout(int height) {
        this.setHeight(height);
    }

    @Override
    public int getMinHeight() {
        return 10;
    }

    @Override
    public int getPreferredHeight() {
        return this.initalHeight;
    }
}

