/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.layout;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public abstract class GuiLayoutControl
extends GuiParent {
    protected Align align = Align.LEFT;
    protected VAlign valign = VAlign.TOP;
    protected int spacing = 2;

    public GuiLayoutControl(String name, int x, int y, int width, int height, Align align, VAlign valign) {
        super(name, x, y, width, height);
        this.align = align;
        this.valign = valign;
    }

    @Override
    public void updateLayout() {
        this.updateLayout(((GuiControl)((Object)this.getParent())).getContentWidth(), ((GuiControl)((Object)this.getParent())).getContentHeight());
    }

    public abstract void updateLayout(int var1, int var2);

    @Override
    public int getPreferredWidth() {
        if (this.align != Align.LEFT) {
            return Integer.MAX_VALUE;
        }
        int width = 0;
        for (GuiControl control : this) {
            width = Math.max(width, control.getPreferredWidth());
        }
        return width;
    }

    @Override
    public int getPreferredHeight() {
        if (this.valign != VAlign.TOP) {
            return Integer.MAX_VALUE;
        }
        int height = 0;
        for (GuiControl control : this) {
            height = Math.max(height, control.getPreferredHeight());
        }
        return height;
    }

    @Override
    public int getMinWidth() {
        int width = 0;
        for (GuiControl control : this) {
            width = Math.max(width, control.getMinWidth());
        }
        return width;
    }

    @Override
    public int getMinHeight() {
        int height = 0;
        for (GuiControl control : this) {
            height = Math.max(height, control.getMinHeight());
        }
        return height;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @Override
    public String getNestedName() {
        if (this.getParent() instanceof GuiControl) {
            return ((GuiControl)((Object)this.getParent())).getNestedName();
        }
        return "";
    }
}

