/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class InfinityEnergyScreenAddon
extends BasicScreenAddon {
    private final InfinityEnergyStorage handler;
    private final long tier;
    private IAsset background;

    public InfinityEnergyScreenAddon(int posX, int posY, InfinityEnergyStorage handler) {
        super(posX, posY);
        this.handler = handler;
        this.tier = handler.getLongCapacity();
    }

    public static List<ITextComponent> getTooltip(long stored, long capacity) {
        return Arrays.asList(new StringTextComponent(TextFormatting.GOLD + "Power:"), new StringTextComponent(new DecimalFormat().format(stored) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(capacity) + TextFormatting.DARK_AQUA + " FE"));
    }

    public int getXSize() {
        return this.background != null ? this.background.getArea().width : 0;
    }

    public int getYSize() {
        return this.background != null ? this.background.getArea().height : 0;
    }

    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.background = EnergyBarScreenAddon.drawBackground((MatrixStack)stack, (Screen)screen, (IAssetProvider)provider, (int)this.getPosX(), (int)this.getPosY(), (int)guiX, (int)guiY);
    }

    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        EnergyBarScreenAddon.drawForeground((MatrixStack)stack, (Screen)screen, (IAssetProvider)provider, (int)this.getPosX(), (int)this.getPosY(), (int)guiX, (int)guiY, (double)this.handler.getLongEnergyStored(), (double)this.tier);
    }

    public List<ITextComponent> getTooltipLines() {
        return InfinityEnergyScreenAddon.getTooltip(this.handler.getLongEnergyStored(), this.tier);
    }
}

