/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well;

import com.yungnickyoung.minecraft.yungsextras.world.WishingWellChances;
import com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractTemplateFeature;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

@ParametersAreNonnullByDefault
public abstract class AbstractDesertWellFeature
extends AbstractTemplateFeature<NoFeatureConfig> {
    private static final String path = "desert/wells/";
    private final int radius;
    protected ResourceLocation name;

    public AbstractDesertWellFeature(String name, int size) {
        super(NoFeatureConfig.field_236558_a_);
        this.name = new ResourceLocation("yungsextras", path + name);
        this.radius = size;
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        while (world.func_175623_d((BlockPos)mutable) && mutable.func_177956_o() > 7) {
            mutable.func_189536_c(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.func_185334_h();
        Block block = world.func_180495_p(surfacePos).func_177230_c();
        if (!BlockTags.field_203436_u.func_230235_a_((Object)block)) {
            return false;
        }
        for (int i = 1; i <= 7; ++i) {
            mutable.func_189533_g((Vector3i)surfacePos).func_189534_c(Direction.DOWN, i);
            if (world.func_175623_d((BlockPos)mutable)) {
                return false;
            }
            mutable.func_189533_g((Vector3i)surfacePos).func_189534_c(Direction.DOWN, i).func_189534_c(Direction.NORTH, this.radius).func_189534_c(Direction.EAST, this.radius);
            if (world.func_175623_d((BlockPos)mutable)) {
                return false;
            }
            mutable.func_189533_g((Vector3i)surfacePos).func_189534_c(Direction.DOWN, i).func_189534_c(Direction.EAST, this.radius).func_189534_c(Direction.SOUTH, this.radius);
            if (world.func_175623_d((BlockPos)mutable)) {
                return false;
            }
            mutable.func_189533_g((Vector3i)surfacePos).func_189534_c(Direction.DOWN, i).func_189534_c(Direction.SOUTH, this.radius).func_189534_c(Direction.WEST, this.radius);
            if (world.func_175623_d((BlockPos)mutable)) {
                return false;
            }
            mutable.func_189533_g((Vector3i)surfacePos).func_189534_c(Direction.DOWN, i).func_189534_c(Direction.WEST, this.radius).func_189534_c(Direction.NORTH, this.radius);
            if (!world.func_175623_d((BlockPos)mutable)) continue;
            return false;
        }
        Template template = this.createTemplate(this.name, world, rand, surfacePos.func_177967_a(Direction.DOWN, 6));
        return template != null;
    }

    @Override
    protected void processTemplate(Template template, ISeedReader world, Random rand, BlockPos cornerPos, PlacementSettings placementSettings) {
        for (Template.BlockInfo blockInfo : template.func_215381_a(cornerPos, placementSettings, Blocks.field_196811_gn)) {
            BlockState blockState = WishingWellChances.get().getRandomLootBlock(rand);
            world.func_180501_a(blockInfo.field_186242_a, blockState, 2);
        }
    }
}

