/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitBlockBakedModel
extends BaseBakedBlockModel {
    public static final float PIXELS_PER_BLOCK = 16.0f;
    private static final float BIT_BEGIN = 6.0f;
    private static final float BIT_END = 10.0f;
    final List<BakedQuad> generic = new ArrayList<BakedQuad>(6);

    public BitBlockBakedModel(BlockState blockState) {
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(6.0f, 6.0f, 6.0f);
        Vector3f from = new Vector3f(10.0f, 10.0f, 10.0f);
        ModelRotation mr = ModelRotation.X0_Y0;
        for (Direction myFace : Direction.values()) {
            for (RenderType layer : RenderType.func_228661_n_()) {
                ModelQuadLayer[] layers = FaceManager.getInstance().getCachedFace(blockState, myFace, layer, 0L);
                if (layers == null || layers.length == 0) continue;
                for (ModelQuadLayer quadLayer : layers) {
                    Vector3f fromB;
                    Vector3f toB;
                    BlockFaceUV uv = new BlockFaceUV(this.getFaceUvs(myFace), 0);
                    BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
                    switch (myFace) {
                        case UP: {
                            toB = new Vector3f(to.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case EAST: {
                            toB = new Vector3f(from.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case NORTH: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                            break;
                        }
                        case SOUTH: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case DOWN: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case WEST: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(to.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                    this.generic.add(faceBakery.func_228824_a_(toB, fromB, bpf, quadLayer.getSprite(), myFace, (IModelTransform)mr, null, false, new ResourceLocation("chiselsandbits", "bit")));
                }
            }
        }
    }

    private float[] getFaceUvs(Direction face) {
        float[] afloat;
        int from_x = 7;
        int from_y = 7;
        int from_z = 7;
        int to_x = 8;
        int to_y = 8;
        int to_z = 8;
        switch (face) {
            case UP: 
            case DOWN: {
                afloat = new float[]{7.0f, 7.0f, 8.0f, 8.0f};
                break;
            }
            case NORTH: 
            case SOUTH: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            case EAST: 
            case WEST: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        return afloat;
    }

    @NotNull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        return this.generic;
    }

    public boolean func_230044_c_() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
    }
}

