/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.InvalidParameterException;
import java.util.Collection;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.culling.MCCullTest;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;

public enum ChiselRenderType {
    SOLID(RenderType.func_228639_c_(), VoxelType.SOLID),
    SOLID_FLUID(RenderType.func_228639_c_(), VoxelType.FLUID),
    CUTOUT(RenderType.func_228643_e_(), VoxelType.UNKNOWN),
    CUTOUT_MIPPED(RenderType.func_228641_d_(), VoxelType.UNKNOWN),
    TRANSLUCENT(RenderType.func_228645_f_(), VoxelType.UNKNOWN),
    TRANSLUCENT_FLUID(RenderType.func_228645_f_(), VoxelType.FLUID),
    TRIPWIRE(RenderType.func_241715_r_(), VoxelType.UNKNOWN);

    public final RenderType layer;
    public final VoxelType type;
    private static final Multimap<VoxelType, ChiselRenderType> TYPED_RENDER_TYPES;

    private ChiselRenderType(RenderType layer, VoxelType type) {
        this.layer = layer;
        this.type = type;
    }

    public boolean isRequiredForRendering(IAreaAccessor accessor) {
        if (accessor == null) {
            return false;
        }
        return accessor.stream().anyMatch(this::isRequiredForRendering);
    }

    public boolean isRequiredForRendering(IStateEntryInfo stateEntryInfo) {
        if (!this.type.isValidBlockState(stateEntryInfo.getState())) {
            return false;
        }
        if (this.type.isFluid()) {
            return RenderTypeLookup.canRenderInLayer((FluidState)stateEntryInfo.getState().func_204520_s(), (RenderType)this.layer);
        }
        return RenderTypeLookup.canRenderInLayer((BlockState)stateEntryInfo.getState(), (RenderType)this.layer);
    }

    public static ChiselRenderType fromLayer(RenderType layerInfo, boolean isFluid) {
        if (layerInfo == null) {
            layerInfo = RenderType.func_228639_c_();
        }
        if (ChiselRenderType.CUTOUT.layer.equals((Object)layerInfo)) {
            return CUTOUT;
        }
        if (ChiselRenderType.CUTOUT_MIPPED.layer.equals((Object)layerInfo)) {
            return CUTOUT_MIPPED;
        }
        if (ChiselRenderType.SOLID.layer.equals((Object)layerInfo)) {
            return isFluid ? SOLID_FLUID : SOLID;
        }
        if (ChiselRenderType.TRANSLUCENT.layer.equals((Object)layerInfo)) {
            return isFluid ? TRANSLUCENT_FLUID : TRANSLUCENT;
        }
        if (ChiselRenderType.TRIPWIRE.layer.equals((Object)layerInfo)) {
            return TRIPWIRE;
        }
        throw new InvalidParameterException();
    }

    public static Collection<ChiselRenderType> getRenderTypes(VoxelType voxelType) {
        return TYPED_RENDER_TYPES.get((Object)voxelType);
    }

    public ICullTest getTest() {
        return new MCCullTest();
    }

    static {
        TYPED_RENDER_TYPES = HashMultimap.create();
        for (ChiselRenderType value : ChiselRenderType.values()) {
            TYPED_RENDER_TYPES.put((Object)value.type, (Object)value);
        }
    }
}

