/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.events;

import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RightClickEventHandler {
    @SubscribeEvent
    public static void onPlayerInteractRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == ModBlocks.BIT_STORAGE.get()) {
            event.setUseBlock(Event.Result.ALLOW);
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() instanceof IRightClickControllingItem) {
            try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Right click processing");){
                IRightClickControllingItem rightClickControllingItem = (IRightClickControllingItem)itemStack.func_77973_b();
                if (!rightClickControllingItem.canUse(event.getPlayer())) {
                    event.setCanceled(true);
                    event.setUseItem(Event.Result.DENY);
                    return;
                }
                ClickProcessingState processingState = rightClickControllingItem.handleRightClickProcessing(event.getPlayer(), event.getHand(), event.getPos(), event.getFace(), new ClickProcessingState(event.isCanceled(), event.getUseItem()));
                if (processingState.shouldCancel()) {
                    event.setCanceled(true);
                }
                event.setUseItem(processingState.getNextState());
            }
        }
    }
}

