/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import java.util.Optional;
import java.util.stream.Stream;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.ColorUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.StateEntryPredicates;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class PlacePatternPlacementType
extends ForgeRegistryEntry<IPatternPlacementType>
implements IPatternPlacementType {
    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, PlayerEntity player, Vector3d targetedPoint, Direction hitFace) {
        return VoxelShapeManager.getInstance().get((IAreaAccessor)sourceSnapshot, accessor -> StateEntryPredicates.NOT_AIR);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockItemUseContext context, boolean simulate) {
        boolean hasRequiredBits;
        Vector3d targetedPosition = context.func_195999_j().func_213453_ef() ? context.func_221532_j() : Vector3d.func_237491_b_((Vector3i)context.func_195995_a());
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((IWorld)context.func_195991_k(), targetedPosition, targetedPosition.func_72441_c(0.9999, 0.9999, 0.9999));
        boolean isAir = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(arg_0 -> ((World)context.func_195991_k()).func_180495_p(arg_0)).allMatch(AbstractBlock.AbstractBlockState::func_196958_f);
        if (!isAir) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (ITextComponent)LocalStrings.PatternPlacementNotAnAirBlock.getText());
        }
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.func_195999_j());
        boolean bl = hasRequiredBits = context.func_195999_j().func_184812_l_() || source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockState)e.getKey()).func_196958_f()).allMatch(e -> playerBitInventory.canExtract((BlockState)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredBits) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (ITextComponent)LocalStrings.PatternPlacementNotEnoughBits.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.func_195999_j()));){
            ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                try {
                    areaMutator.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!context.func_195999_j().func_184812_l_()) {
            source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockState)e.getKey()).func_196958_f()).forEach(e -> playerBitInventory.extract((BlockState)e.getKey(), (Integer)e.getValue()));
        }
        return PlacementResult.success();
    }

    @Override
    public Vector3d getTargetedPosition(ItemStack heldStack, PlayerEntity playerEntity, BlockRayTraceResult blockRayTraceResult) {
        if (playerEntity.func_213453_ef()) {
            return blockRayTraceResult.func_216347_e();
        }
        return Vector3d.func_237491_b_((Vector3i)blockRayTraceResult.func_216350_a().func_177971_a(blockRayTraceResult.func_216354_b().func_176730_m()));
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_place.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public ITextComponent getDisplayName() {
        return LocalStrings.PatternPlacementModePlacement.getText();
    }
}

