/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.api;

import java.util.function.Function;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DynamicLightHandler<T> {
    public int getLuminance(T var1);

    default public boolean isWaterSensitive(T lightSource) {
        return false;
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeHandler(final Function<T, Integer> luminance, final Function<T, Boolean> waterSensitive) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T lightSource) {
                return (Integer)luminance.apply(lightSource);
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return (Boolean)waterSensitive.apply(lightSource);
            }
        };
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeLivingEntityHandler(@NotNull DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = 0;
            for (ItemStack equipped : entity.func_184209_aF()) {
                luminance = Math.max(luminance, DynamicLightsReforged.getLuminanceFromItemStack(equipped, entity.func_204231_K()));
            }
            return Math.max(luminance, handler.getLuminance(entity));
        };
    }

    @NotNull
    public static <T extends CreeperEntity> DynamicLightHandler<T> makeCreeperEntityHandler(final @Nullable DynamicLightHandler<T> handler) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T entity) {
                int luminance = (int)((double)entity.func_70831_j(0.0f) * 10.0);
                if (handler != null) {
                    luminance = Math.max(luminance, handler.getLuminance(entity));
                }
                return luminance;
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return true;
            }
        };
    }
}

