/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import org.aperlambda.lambdacommon.utils.Nameable;
import org.jetbrains.annotations.NotNull;

public class Identifier
implements Nameable {
    protected final String domain;
    protected final String name;
    public static final Identifier IDENTIFIER_INVALID = new Identifier("common", "invalid");
    public static final Identifier IDENTIFIER_NOT_FOUND = new Identifier("common", "404");

    public Identifier(String resource) {
        String[] res = Identifier.getInTwoParts(resource);
        this.domain = res[0];
        this.name = res[1];
    }

    public Identifier(String domain, @NotNull String name) {
        this.domain = domain;
        this.name = name;
    }

    public Identifier(Identifier identifier, String name) {
        this(identifier.domain, Identifier.mergePath(identifier.name, name));
    }

    private static String mergePath(String parent, String child) {
        String merged = parent;
        merged = parent.endsWith("/") || child.startsWith("/") ? merged + child : merged + '/' + child;
        return merged;
    }

    private static String[] getInTwoParts(String o) {
        int index = o.indexOf(58);
        if (index <= 0) {
            throw new IllegalArgumentException("The given string isn't a valid resource name!");
        }
        return new String[]{o.substring(0, index), o.substring(index + 1)};
    }

    public String getNamespace() {
        return this.domain;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public Identifier sub(String path) {
        return new Identifier(this, path);
    }

    public String toString() {
        return this.domain + ':' + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.domain, that.domain) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.domain != null ? this.domain.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static class IdentifierJsonSerializer
    implements JsonDeserializer<Identifier>,
    JsonSerializer<Identifier> {
        public Identifier deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new Identifier(json.getAsString());
            }
            throw new JsonSyntaxException("Expected resource name to be a string, was " + json.getClass().getSimpleName());
        }

        public JsonElement serialize(Identifier identifier, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(identifier.toString());
        }
    }
}

