/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.AEAddon;
import appeng.api.IAEAddon;
import appeng.api.IAppEngApi;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.commons.codec.binary.Hex;

@AEAddon
public class AppEngApi
implements IAEAddon {
    public static final AppEngApi INSTANCE = new AppEngApi();
    private static IAppEngApi api;

    public static AppEngApi getInstance() {
        return INSTANCE;
    }

    public void onAPIAvailable(IAppEngApi iAppEngApi) {
        api = iAppEngApi;
    }

    public IAppEngApi getApi() {
        return api;
    }

    public IAEItemStack findAEStackFromItemStack(IMEMonitor<IAEItemStack> monitor, ItemStack item) {
        IAEItemStack stack = null;
        for (IAEItemStack temp : monitor.getStorageList()) {
            if (!temp.isSameType(item)) continue;
            stack = temp;
            break;
        }
        return stack;
    }

    public List<Object> iteratorToMapStack(Iterator<IAEItemStack> iterator, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object item = this.getObjectFromStack(iterator.next(), flag);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public List<Object> iteratorToMapFluid(Iterator<IAEFluidStack> iterator, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object item = this.getObjectFromStack(iterator.next(), flag);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public Object getObjectFromStack(IAEItemStack stack, int flag) {
        Map<Object, Object> map = this.getMapFromStack(stack);
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? stack.getStackSize() > 0L : flag == 2 && stack.isCraftable()) {
            return map;
        }
        return null;
    }

    public Map<Object, Object> getMapFromStack(IAEItemStack stack) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String displayName = stack.createItemStack().func_151000_E().getString();
        CompoundNBT nbt = stack.createItemStack().func_196082_o();
        map.put("fingerprint", this.getFingerpint(stack));
        map.put("name", stack.getItem().getRegistryName().toString());
        map.put("amount", stack.getStackSize());
        map.put("count", stack.getStackSize());
        map.put("displayName", displayName);
        map.put("nbt", NBTUtil.toLua((INBT)nbt));
        map.put("tags", LuaConverter.tagsToList(stack.getItem().getTags()));
        map.put("isCraftable", stack.isCraftable());
        return map;
    }

    public Object getObjectFromStack(IAEFluidStack stack, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", stack.getFluidStack().getFluid().getRegistryName().toString());
        map.put("amount", stack.getFluidStack().getAmount());
        map.put("count", stack.getFluidStack().getAmount());
        map.put("displayName", stack.getFluidStack().getDisplayName());
        map.put("tags", LuaConverter.tagsToList(stack.getFluid().getTags()));
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? stack.getStackSize() > 0L : flag == 2 && stack.isCraftable()) {
            return map;
        }
        return null;
    }

    public Object getObjectFromCPU(ICraftingCPU cpu) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        map.put("storage", Long.valueOf(storage));
        map.put("coProcessors", Integer.valueOf(coProcessors));
        map.put("isBusy", Boolean.valueOf(isBusy));
        return map;
    }

    public Object getObjectFromJob(ICraftingJob job) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashMap<String, Map<Object, Object>> stack = new HashMap<String, Map<Object, Object>>();
        stack.put("item", this.getMapFromStack(job.getOutput()));
        result.put("stack", stack);
        result.put("bytes", Long.valueOf(job.getByteTotal()));
        return result;
    }

    public CompoundNBT findMatchingTag(ItemStack stack, String nbtHash, IMEMonitor<IAEItemStack> monitor) {
        IItemList itemStacks = monitor.getStorageList();
        for (IAEItemStack aeStack : itemStacks) {
            CompoundNBT tag;
            String hash;
            if (aeStack.getStackSize() <= 0L || !aeStack.getItem().equals(stack.func_77973_b()) || !nbtHash.equals(hash = NBTUtil.getNBTHash((CompoundNBT)(tag = aeStack.createItemStack().func_77978_p())))) continue;
            return tag.func_74737_b();
        }
        return null;
    }

    public ItemStack findMatchingFingerprint(String fingerprint, IMEMonitor<IAEItemStack> monitor) {
        IItemList itemStacks = monitor.getStorageList();
        for (IAEItemStack aeStack : itemStacks) {
            if (aeStack.getStackSize() <= 0L || !fingerprint.equals(this.getFingerpint(aeStack))) continue;
            return aeStack.createItemStack();
        }
        return null;
    }

    public String getFingerpint(IAEItemStack itemStack) {
        ItemStack stack = itemStack.createItemStack();
        String fingerprint = stack.func_196082_o() + stack.func_77973_b().getRegistryName().toString() + stack.func_151000_E().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new String(Hex.encodeHex((byte[])md.digest(bytesOfHash)));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.");
            ex.printStackTrace();
            return "";
        }
    }
}

