/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class AutomataEntityHandPlugin
extends AutomataCorePlugin {
    private final Predicate<Entity> suitableEntity;

    public AutomataEntityHandPlugin(AutomataCorePeripheral automataCore, Predicate<Entity> suitableEntity) {
        super(automataCore);
        this.suitableEntity = suitableEntity;
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.USE_ON_ANIMAL};
    }

    @LuaFunction(mainThread=true)
    public final MethodResult useOnAnimal() throws LuaException {
        return this.automataCore.withOperation(SingleOperation.USE_ON_ANIMAL, context -> {
            TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
            ItemStack selectedTool = owner.getToolInMainHand();
            int previousDamageValue = selectedTool.func_77952_i();
            ActionResultType result = owner.withPlayer(player -> player.useOnFilteredEntity(this.suitableEntity));
            if (this.automataCore.hasAttribute("storingToolDurability")) {
                selectedTool.func_196085_b(previousDamageValue);
            }
            return MethodResult.of((Object[])new Object[]{true, result.toString()});
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult inspectAnimal() {
        this.automataCore.addRotationCycle();
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        RayTraceResult entityHit = owner.withPlayer(player -> player.findHit(false, true, this.suitableEntity));
        if (entityHit.func_216346_c() == RayTraceResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "Nothing found"});
        }
        Entity entity = ((EntityRayTraceResult)entityHit).func_216348_a();
        if (!(entity instanceof AnimalEntity)) {
            return MethodResult.of((Object[])new Object[]{null, "Well, entity is not animal entity, but how?"});
        }
        return MethodResult.of(LuaConverter.animalToLua((AnimalEntity)entity, owner.getToolInMainHand()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult searchAnimals() {
        this.automataCore.addRotationCycle();
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        BlockPos currentPos = owner.getPos();
        AxisAlignedBB box = new AxisAlignedBB(currentPos);
        ArrayList entities = new ArrayList();
        ItemStack itemInHand = owner.getToolInMainHand();
        owner.getWorld().func_175674_a((Entity)null, box.func_186662_g((double)this.automataCore.getInteractionRadius()), this.suitableEntity).forEach(entity -> entities.add(LuaConverter.completeEntityWithPositionToLua(entity, itemInHand, currentPos)));
        return MethodResult.of(entities);
    }
}

