/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class PeripheralsConfig
implements IAPConfig {
    public final ForgeConfigSpec.IntValue PLAYER_DET_MAX_RANGE;
    public final ForgeConfigSpec.BooleanValue PLAYER_SPY;
    public final ForgeConfigSpec.BooleanValue MORE_PLAYER_INFORMATION;
    public final ForgeConfigSpec.BooleanValue ENABLE_PLAYER_DETECTOR;
    public final ForgeConfigSpec.IntValue ENERGY_DETECTOR_MAX_FLOW;
    public final ForgeConfigSpec.BooleanValue ENABLE_ENERGY_DETECTOR;
    public final ForgeConfigSpec.IntValue NBT_STORAGE_MAX_SIZE;
    public final ForgeConfigSpec.BooleanValue ENABLE_NBT_STORAGE;
    public final ForgeConfigSpec.IntValue CHUNK_LOAD_VALID_TIME;
    public final ForgeConfigSpec.BooleanValue ENABLE_CHUNKY_TURTLE;
    public final ForgeConfigSpec.BooleanValue ENABLE_CHAT_BOX;
    public final ForgeConfigSpec.ConfigValue<String> DEFAULT_CHAT_BOX_PREFIX;
    public final ForgeConfigSpec.BooleanValue ENABLE_ME_BRIDGE;
    public final ForgeConfigSpec.IntValue ME_CONSUMPTION;
    public final ForgeConfigSpec.BooleanValue ENABLE_RS_BRIDGE;
    public final ForgeConfigSpec.IntValue RS_CONSUMPTION;
    public final ForgeConfigSpec.BooleanValue ENABLE_ENVIRONMENT_DETECTOR;
    public final ForgeConfigSpec.BooleanValue ENABLE_AR_GOGGLES;
    public final ForgeConfigSpec.BooleanValue ENABLE_INVENTORY_MANAGER;
    public final ForgeConfigSpec.BooleanValue ENABLE_REDSTONE_INTEGRATOR;
    public final ForgeConfigSpec.BooleanValue ENABLE_BLOCK_READER;
    public final ForgeConfigSpec.BooleanValue ENABLE_GEO_SCANNER;
    public final ForgeConfigSpec.BooleanValue ENABLE_COLONY_INTEGRATOR;
    public final ForgeConfigSpec.BooleanValue ENABLE_POWERED_PERIPHERALS;
    public final ForgeConfigSpec.IntValue POWERED_PERIPHERAL_MAX_ENERGY_STORAGE;
    private final ForgeConfigSpec configSpec;

    public PeripheralsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Peripherals config").push("Peripherals");
        builder.push("Player_Detector");
        this.ENABLE_PLAYER_DETECTOR = builder.comment("Enable the Player Detector or not.").define("enablePlayerDetector", true);
        this.PLAYER_DET_MAX_RANGE = builder.comment("The max range of the player detector functions. If anyone use a higher range, the detector will use this max range").defineInRange("playerDetMaxRange", 100000000, 0, 100000000);
        this.PLAYER_SPY = builder.comment("Activates the \"getPlayerPos\" function of the Player Detector").define("enablePlayerPosFunction", true);
        this.MORE_PLAYER_INFORMATION = builder.comment("Adds more information to `getPlayerPos` of the Player Detector. Like rotation and dimension").define("morePlayerInformation", true);
        this.pop("Energy_Detector", builder);
        this.ENABLE_ENERGY_DETECTOR = builder.comment("Enable the Energy Detector or not.").define("enableEnergyDetector", true);
        this.ENERGY_DETECTOR_MAX_FLOW = builder.comment("Defines the maximum energy flow of the energy detector.").defineInRange("energyDetectorMaxFlow", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.pop("NBT_Storage", builder);
        this.ENABLE_NBT_STORAGE = builder.comment("Enable the nbt storage block or not").define("enableNBTStorage", true);
        this.NBT_STORAGE_MAX_SIZE = builder.comment("Defines max nbt string length that can be stored in nbt storage").defineInRange("nbtStorageMaxSize", 0x100000, 0, Integer.MAX_VALUE);
        this.pop("Chunky_Turtle", builder);
        this.ENABLE_CHUNKY_TURTLE = builder.comment("Enable the Chunky Turtle or not.").define("enableChunkyTurtle", true);
        this.CHUNK_LOAD_VALID_TIME = builder.comment("Time in seconds, while loaded chunk can be consider as valid without touch").defineInRange("chunkLoadValidTime", 600, 60, Integer.MAX_VALUE);
        this.pop("Chat_Box", builder);
        this.ENABLE_CHAT_BOX = builder.comment("Enable the Chat Box or not.").define("enableChatBox", true);
        this.DEFAULT_CHAT_BOX_PREFIX = builder.comment("Defines default chatbox prefix").define("defaultChatBoxPrefix", (Object)"AP");
        this.pop("ME_Bridge", builder);
        this.ENABLE_ME_BRIDGE = builder.comment("Enable the Me Bridge or not.").define("enableMeBridge", true);
        this.ME_CONSUMPTION = builder.comment("Power consumption per tick.").defineInRange("mePowerConsumption", 500, 0, Integer.MAX_VALUE);
        this.pop("RS_Bridge", builder);
        this.ENABLE_RS_BRIDGE = builder.comment("Enable the Rs Bridge or not.").define("enableRsBridge", true);
        this.RS_CONSUMPTION = builder.comment("Power consumption per tick.").defineInRange("rsPowerConsumption", 500, 0, Integer.MAX_VALUE);
        this.pop("Environment_Detector", builder);
        this.ENABLE_ENVIRONMENT_DETECTOR = builder.comment("Enable the Environment Detector or not.").define("enableEnvironmentDetector", true);
        this.pop("AR_Controller", builder);
        this.ENABLE_AR_GOGGLES = builder.comment("Enable the AR goggles or not.").define("enableARGoggles", true);
        this.pop("Inventory_Manager", builder);
        this.ENABLE_INVENTORY_MANAGER = builder.comment("Enable the inventory manager or not.").define("enableInventoryManager", true);
        this.pop("Redstone_Integrator", builder);
        this.ENABLE_REDSTONE_INTEGRATOR = builder.comment("Enable the redstone integrator or not.").define("enableRedstoneIntegrator", true);
        this.pop("Block_Reader", builder);
        this.ENABLE_BLOCK_READER = builder.comment("Enable the block reader or not.").define("enableBlockReader", true);
        this.pop("Geo_Scanner", builder);
        this.ENABLE_GEO_SCANNER = builder.comment("Enable the geo scanner or not.").define("enableGeoScanner", true);
        this.pop("Colony_Integrator", builder);
        this.ENABLE_COLONY_INTEGRATOR = builder.comment("Enable the colony integrator or not.").define("enableColonyIntegrator", true);
        this.pop("Powered_Peripherals", builder);
        this.ENABLE_POWERED_PERIPHERALS = builder.comment("Enable RF storage for peripherals, that could use it").define("enablePoweredPeripherals", false);
        this.POWERED_PERIPHERAL_MAX_ENERGY_STORAGE = builder.comment("Defines max energy storage in any powered peripheral").defineInRange("poweredPeripheralMaxEnergyStored", 100000000, 1000000, Integer.MAX_VALUE);
        this.pop("Operations", builder);
        this.register(SingleOperation.values(), builder);
        this.register(SphereOperation.values(), builder);
        this.register(SimpleFreeOperation.values(), builder);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public String getFileName() {
        return "peripherals";
    }

    @Override
    public ModConfig.Type getType() {
        return ModConfig.Type.COMMON;
    }
}

