/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.APItem;
import de.srendi.advancedperipherals.common.setup.Items;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.lib.metaphysics.IFeedableAutomataCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakAutomataCore
extends APItem
implements IFeedableAutomataCore {
    private static final String CONSUMED_ENTITY_COUNT = "consumed_entity_count";
    private static final String CONSUMED_ENTITY_NAME = "consumed_entity_name";
    private static final String CONSUMER_ENTITY_COMPOUND = "consumed_entity_compound";
    private static final Map<String, WeakAutomataCoreRecord> AUTOMATA_CORE_REGISTRY = new HashMap<String, WeakAutomataCoreRecord>(){
        {
            WeakAutomataCoreRecord endSoulRecord = new WeakAutomataCoreRecord((Map<String, Integer>)new HashMap<String, Integer>(){
                {
                    this.put(EntityType.field_200803_q.getRegistryName().toString(), 10);
                }
            }, (Item)Items.END_AUTOMATA_CORE.get());
            WeakAutomataCoreRecord husbandrySoulRecord = new WeakAutomataCoreRecord((Map<String, Integer>)new HashMap<String, Integer>(){
                {
                    this.put(EntityType.field_200796_j.getRegistryName().toString(), 3);
                    this.put(EntityType.field_200737_ac.getRegistryName().toString(), 3);
                    this.put(EntityType.field_200795_i.getRegistryName().toString(), 3);
                }
            }, (Item)Items.HUSBANDRY_AUTOMATA_CORE.get());
            endSoulRecord.ingredients.keySet().forEach((? super T entityType) -> this.put(entityType, endSoulRecord));
            husbandrySoulRecord.ingredients.keySet().forEach((? super T entityType) -> this.put(entityType, husbandrySoulRecord));
        }
    };

    public WeakAutomataCore(Item.Properties properties, @Nullable ResourceLocation turtleID, @Nullable ResourceLocation pocketID) {
        super(properties, turtleID, pocketID, () -> ((ForgeConfigSpec.BooleanValue)APConfig.METAPHYSICS_CONFIG.ENABLE_WEAK_AUTOMATA_CORE).get());
    }

    public WeakAutomataCore(@Nullable ResourceLocation turtleID, @Nullable ResourceLocation pocketID) {
        super(turtleID, pocketID, () -> ((ForgeConfigSpec.BooleanValue)APConfig.METAPHYSICS_CONFIG.ENABLE_WEAK_AUTOMATA_CORE).get());
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_196082_o();
        CompoundNBT consumedData = tag.func_74775_l(CONSUMER_ENTITY_COMPOUND);
        consumedData.func_150296_c().forEach(key -> {
            WeakAutomataCoreRecord record = AUTOMATA_CORE_REGISTRY.get(key);
            CompoundNBT recordData = consumedData.func_74775_l(key);
            tooltip.add(EnumColor.buildTextComponent((ITextComponent)new StringTextComponent(String.format("Consumed: %d/%d %s", recordData.func_74762_e(CONSUMED_ENTITY_COUNT), record.getRequiredCount((String)key), recordData.func_74779_i(CONSUMED_ENTITY_NAME)))));
        });
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, @NotNull PlayerEntity player, @NotNull LivingEntity entity, @NotNull Hand hand) {
        if (!(player instanceof FakePlayer)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.advancedperipherals.automata_core_feed_by_player"), true);
            return ActionResultType.FAIL;
        }
        String entityType = EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString();
        Class<?> entityClass = entity.getClass();
        if (AUTOMATA_CORE_REGISTRY.containsKey(entityType)) {
            WeakAutomataCoreRecord record;
            CompoundNBT tag = stack.func_196082_o();
            CompoundNBT consumedData = tag.func_74775_l(CONSUMER_ENTITY_COMPOUND);
            if (consumedData.isEmpty()) {
                record = AUTOMATA_CORE_REGISTRY.get(entityType);
            } else {
                Optional anyKey = consumedData.func_150296_c().stream().findAny();
                if (!anyKey.isPresent()) {
                    return ActionResultType.PASS;
                }
                record = AUTOMATA_CORE_REGISTRY.get(anyKey.get());
            }
            if (!record.isSuitable(entityType, consumedData)) {
                return ActionResultType.PASS;
            }
            entity.func_70106_y();
            CompoundNBT entityCompound = consumedData.func_74775_l(entityType);
            entityCompound.func_74768_a(CONSUMED_ENTITY_COUNT, entityCompound.func_74762_e(CONSUMED_ENTITY_COUNT) + 1);
            entityCompound.func_74778_a(CONSUMED_ENTITY_NAME, entity.func_200200_C_().getString());
            consumedData.func_218657_a(entityType, (INBT)entityCompound);
            if (record.isFinished(consumedData)) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)record.resultSoul));
            }
            tag.func_218657_a(CONSUMER_ENTITY_COMPOUND, (INBT)consumedData);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static class WeakAutomataCoreRecord {
        public final Map<String, Integer> ingredients;
        public final Item resultSoul;

        public WeakAutomataCoreRecord(Map<String, Integer> ingredients, Item resultSoul) {
            this.ingredients = ingredients;
            this.resultSoul = resultSoul;
        }

        public int getRequiredCount(String entityType) {
            return this.ingredients.getOrDefault(entityType, 0);
        }

        public boolean isSuitable(String entityType, CompoundNBT consumedData) {
            if (!this.ingredients.containsKey(entityType)) {
                return false;
            }
            int requiredCount = this.ingredients.get(entityType);
            int currentCount = consumedData.func_74775_l(entityType).func_74762_e(WeakAutomataCore.CONSUMED_ENTITY_COUNT);
            return currentCount < requiredCount;
        }

        public boolean isFinished(CompoundNBT consumedData) {
            return this.ingredients.entrySet().stream().map(entry -> ((Integer)entry.getValue()).intValue() == consumedData.func_74775_l((String)entry.getKey()).func_74762_e(WeakAutomataCore.CONSUMED_ENTITY_COUNT)).reduce((a, b) -> a != false && b != false).orElse(true);
        }
    }
}

