/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.network.PacketExecutor;
import mcp.mobius.waila.network.PacketIo;
import mcp.mobius.waila.network.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgePacketSender
extends PacketSender {
    static final String PROTOCOL = "1.0.0";
    static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)Waila.id("networking"), () -> "1.0.0", p -> true, p -> true);

    @Override
    public void initMain() {
        int i = 0;
        NETWORK.registerMessage(i++, ReceiveData.class, (msg, buf) -> PacketIo.ReceiveData.write((PacketBuffer)buf, msg.tag), buf -> PacketIo.ReceiveData.apply((PacketBuffer)buf, ReceiveData::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketExecutor.receiveData(msg.tag));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, SendConfig.class, (msg, buf) -> PacketIo.SendConfig.write((PacketBuffer)buf, msg.config), buf -> PacketIo.SendConfig.apply((PacketBuffer)buf, SendConfig::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketExecutor.sendConfig(msg.forcedKeys));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, RequestEntity.class, (msg, buf) -> PacketIo.RequestEntity.write((PacketBuffer)buf, msg.entity), buf -> PacketIo.RequestEntity.apply((PacketBuffer)buf, RequestEntity::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgePacketSender.lambda$initMain$15((Supplier)ctx, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, RequestBlock.class, (msg, buf) -> PacketIo.RequestBlock.write((PacketBuffer)buf, msg.blockEntity), buf -> PacketIo.RequestBlock.apply((PacketBuffer)buf, RequestBlock::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgePacketSender.lambda$initMain$21((Supplier)ctx, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    @Override
    public void sendConfig(PluginConfig config, ServerPlayerEntity player) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendConfig(config));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isServerAvailable() {
        return NETWORK.isRemotePresent(Minecraft.func_71410_x().func_147114_u().func_147298_b());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void requestEntity(Entity entity) {
        NETWORK.sendToServer((Object)new RequestEntity(entity));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void requestBlock(TileEntity blockEntity) {
        NETWORK.sendToServer((Object)new RequestBlock(blockEntity));
    }

    private static /* synthetic */ void lambda$initMain$21(Supplier ctx, RequestBlock msg) {
        ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
        PacketExecutor.requestBlockEntity(player, msg.pos, tag -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ReceiveData((CompoundNBT)tag)));
    }

    private static /* synthetic */ void lambda$initMain$15(Supplier ctx, RequestEntity msg) {
        ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
        PacketExecutor.requestEntity(player, msg.entityId, tag -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ReceiveData((CompoundNBT)tag)));
    }

    public static class ReceiveData {
        public CompoundNBT tag;

        public ReceiveData(CompoundNBT tag) {
            this.tag = tag;
        }
    }

    public static class SendConfig {
        Map<ResourceLocation, Boolean> forcedKeys;
        PluginConfig config;

        SendConfig(@Nullable Map<ResourceLocation, Boolean> forcedKeys) {
            this.forcedKeys = forcedKeys;
        }

        SendConfig(PluginConfig config) {
            this.config = config;
        }
    }

    public static class RequestEntity {
        int entityId;
        Entity entity;

        RequestEntity(Entity entity) {
            this.entity = entity;
        }

        RequestEntity(int entityId) {
            this.entityId = entityId;
        }
    }

    public static class RequestBlock {
        BlockPos pos;
        TileEntity blockEntity;

        RequestBlock(TileEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        RequestBlock(BlockPos pos) {
            this.pos = pos;
        }
    }
}

