/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mcp.mobius.waila.Waila;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionHandler {
    private static final ArrayList<String> ERRORS = new ArrayList();
    private static final File ERROR_OUTPUT = new File("WailaErrorOutput.txt");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy - HH:mm:ss");

    public static void handleErr(Throwable e, String className, List<ITextComponent> tooltip) {
        if (!ERRORS.contains(className)) {
            ERRORS.add(className);
            Waila.LOGGER.error("Caught unhandled exception : [{}] {}", (Object)className, (Object)e);
            Waila.LOGGER.error("See WailaErrorOutput.txt for more information");
            try {
                FileUtils.writeStringToFile((File)ERROR_OUTPUT, (String)(DATE_FORMAT.format(new Date()) + "\n" + className + "\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tooltip != null) {
            tooltip.add((ITextComponent)new StringTextComponent("<ERROR>"));
        }
    }
}

