/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.natives.util;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.natives.NativeSetupException;
import com.velocitypowered.natives.compression.Java11VelocityCompressor;
import com.velocitypowered.natives.compression.JavaVelocityCompressor;
import com.velocitypowered.natives.compression.LibdeflateVelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.JavaVelocityCipher;
import com.velocitypowered.natives.encryption.NativeVelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.NativeCodeLoader;
import com.velocitypowered.natives.util.NativeConstraints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class Natives {
    public static final NativeCodeLoader<VelocityCompressorFactory> compress = new NativeCodeLoader(ImmutableList.of(new NativeCodeLoader.Variant<VelocityCompressorFactory>(NativeConstraints.LINUX_X86_64, Natives.copyAndLoadNative("/linux_x86_64/velocity-compress.so"), "libdeflate (Linux x86_64)", LibdeflateVelocityCompressor.FACTORY), new NativeCodeLoader.Variant<VelocityCompressorFactory>(NativeConstraints.LINUX_AARCH64, Natives.copyAndLoadNative("/linux_aarch64/velocity-compress.so"), "libdeflate (Linux aarch64)", LibdeflateVelocityCompressor.FACTORY), new NativeCodeLoader.Variant<VelocityCompressorFactory>(NativeConstraints.JAVA_11, () -> {}, "Java 11", () -> Java11VelocityCompressor.FACTORY), new NativeCodeLoader.Variant<VelocityCompressorFactory>(NativeCodeLoader.ALWAYS, () -> {}, "Java", JavaVelocityCompressor.FACTORY)));
    public static final NativeCodeLoader<VelocityCipherFactory> cipher = new NativeCodeLoader(ImmutableList.of(new NativeCodeLoader.Variant<VelocityCipherFactory>(NativeConstraints.LINUX_X86_64, Natives.copyAndLoadNative("/linux_x86_64/velocity-cipher.so"), "OpenSSL local (Linux x86_64)", NativeVelocityCipher.FACTORY), new NativeCodeLoader.Variant<VelocityCipherFactory>(NativeConstraints.LINUX_X86_64, Natives.copyAndLoadNative("/linux_x86_64/velocity-cipher-ossl11x.so"), "OpenSSL 1.1.x (Linux x86_64)", NativeVelocityCipher.FACTORY), new NativeCodeLoader.Variant<VelocityCipherFactory>(NativeConstraints.LINUX_X86_64, Natives.copyAndLoadNative("/linux_x86_64/velocity-cipher-ossl10x.so"), "OpenSSL 1.0.x (Linux x86_64)", NativeVelocityCipher.FACTORY), new NativeCodeLoader.Variant<VelocityCipherFactory>(NativeConstraints.LINUX_AARCH64, Natives.copyAndLoadNative("/linux_aarch64/velocity-cipher.so"), "OpenSSL (Linux aarch64)", NativeVelocityCipher.FACTORY), new NativeCodeLoader.Variant<VelocityCipherFactory>(NativeCodeLoader.ALWAYS, () -> {}, "Java", JavaVelocityCipher.FACTORY)));

    private Natives() {
        throw new AssertionError();
    }

    private static Runnable copyAndLoadNative(String path) {
        return () -> {
            try {
                InputStream nativeLib = Natives.class.getResourceAsStream(path);
                if (nativeLib == null) {
                    throw new IllegalStateException("Native library " + path + " not found.");
                }
                Path tempFile = Natives.createTemporaryNativeFilename(path.substring(path.lastIndexOf(46)));
                Files.copy(nativeLib, tempFile, StandardCopyOption.REPLACE_EXISTING);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
                try {
                    System.load(tempFile.toAbsolutePath().toString());
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeSetupException("Unable to load native " + tempFile.toAbsolutePath(), e);
                }
            }
            catch (IOException e) {
                throw new NativeSetupException("Unable to copy natives", e);
            }
        };
    }

    private static Path createTemporaryNativeFilename(String ext) throws IOException {
        String temporaryFolderPath = System.getProperty("velocity.natives-tmpdir");
        if (temporaryFolderPath != null) {
            return Files.createTempFile(Paths.get(temporaryFolderPath, new String[0]), "native-", ext, new FileAttribute[0]);
        }
        return Files.createTempFile("native-", ext, new FileAttribute[0]);
    }
}

