/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.asm.StackAnalyser;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MixinInfo;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Utils {
    public static String asmName(Class<?> clazz) {
        return Utils.asmName(clazz.getName());
    }

    public static String asmName(String name) {
        return name.replace(".", "/");
    }

    public static <E> Iterable<E> toIterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Optional<Constructor<T>> findConstructor(Class<T> clazz, Class<?> ... parameters) {
        try {
            return Optional.of(clazz.getConstructor(parameters));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public static <T> T newInstance(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate class.", e);
        }
    }

    public static <T> Stream<T> of(T thing) {
        return thing != null ? Stream.of(thing) : Stream.empty();
    }

    public static <T> List<T> of(T first, List<T> rest) {
        if (first == null) {
            return rest;
        }
        ArrayList<T> list = new ArrayList<T>(rest.size() + 1);
        list.add(first);
        list.addAll(rest);
        return list;
    }

    public static void deleteFolder(Path folder) throws IOException {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static String staticDesc(String owner, String desc) {
        Type descT = Type.getMethodType((String)desc);
        ArrayList<Type> args = new ArrayList<Type>(Arrays.asList(descT.getArgumentTypes()));
        args.add(0, Type.getType((String)("L" + owner + ";")));
        return Type.getMethodDescriptor((Type)descT.getReturnType(), (Type[])args.toArray(new Type[0]));
    }

    public static String timeString(long start, long end) {
        long delta = end - start;
        long millis = TimeUnit.NANOSECONDS.toMillis(delta);
        String s = millis >= 5L ? millis + "ms(" + delta + "ns)" : delta + "ns";
        return s;
    }

    public static Stream<ClassInfo> allParents(ClassInfo info) {
        return Streams.concat((Stream[])new Stream[]{Utils.of(info), Streams.concat((Stream[])new Stream[]{Streams.stream(info.getSuperClass()), info.getInterfaces()}).flatMap(Utils::allParents)});
    }

    @Deprecated
    public static void finishBridgeCall(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc) {
        Utils.finishBridgeCall(mv, mvDesc, opcode, owner, name, desc, opcode == 185);
    }

    public static void finishBridgeCall(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc, boolean isInterface) {
        Type[] args = Type.getArgumentTypes((String)mvDesc);
        Type returnType = Type.getReturnType((String)mvDesc);
        int localIndex = 1;
        for (Type arg : args) {
            mv.visitVarInsn(arg.getOpcode(21), localIndex);
            localIndex += StackAnalyser.width(arg);
        }
        mv.visitMethodInsn(opcode, owner, name, desc, isInterface);
        mv.visitInsn(returnType.getOpcode(172));
        mv.visitMaxs(-1, -1);
    }

    @Deprecated
    public static void writeBridge(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc) {
        Utils.writeBridge(mv, mvDesc, opcode, owner, name, desc, opcode == 185);
    }

    public static void writeBridge(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc, boolean isInterface) {
        mv.visitVarInsn(25, 0);
        Utils.finishBridgeCall(mv, mvDesc, opcode, owner, name, desc, isInterface);
    }

    public static void writeStaticBridge(MethodNode mv, String mName, MixinInfo info) {
        Utils.writeBridge((MethodVisitor)mv, mv.desc, 184, info.getName(), mName + "$", Utils.staticDesc(info.getName(), mv.desc), true);
    }

    public static boolean isScalaClass(ClassNode node) {
        return node.visibleAnnotations.stream().anyMatch(e -> e.desc.equals("Lscala/reflect/ScalaSignature;"));
    }

    public static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }
}

