/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.part.redstone.IFaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.ModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class LeverPart
extends McSidedStatePart
implements IFaceRedstonePart {
    public LeverPart() {
    }

    public LeverPart(BlockState state) {
        super(state);
    }

    @Override
    public MultiPartType<?> getType() {
        return ModContent.leverPartType;
    }

    @Override
    public BlockState defaultBlockState() {
        return Blocks.field_150442_at.func_176223_P();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((IItemProvider)Blocks.field_150442_at);
    }

    public boolean active() {
        return (Boolean)this.state.func_177229_b((Property)LeverBlock.field_176359_b);
    }

    @Override
    public Direction getSide() {
        return HorizontalFaceBlock.func_196365_i((BlockState)this.state).func_176734_d();
    }

    @Override
    public ActionResultType activate(PlayerEntity player, PartRayTraceResult hit, ItemStack item, Hand hand) {
        if (this.world().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.state = (BlockState)this.state.func_235896_a_((Property)LeverBlock.field_176359_b);
        this.world().func_184133_a(null, this.pos(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, this.active() ? 0.6f : 0.5f);
        this.sendUpdate(this::writeDesc);
        this.tile().func_70296_d();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
        return ActionResultType.SUCCESS;
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public void onConverted() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.active() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        if (this.active()) {
            LeverBlock.func_196379_a((BlockState)this.state, (IWorld)this.world(), (BlockPos)this.pos(), (float)1.0f);
        }
    }
}

