/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.TRandomTickPart;
import codechicken.multipart.api.part.redstone.IFaceRedstonePart;
import codechicken.multipart.minecraft.ModContent;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.TickScheduler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class RedstoneTorchPart
extends TorchPart
implements IFaceRedstonePart,
TRandomTickPart {
    private BurnoutEntry burnout;

    public RedstoneTorchPart() {
    }

    public RedstoneTorchPart(BlockState state) {
        super(state);
    }

    @Override
    public MultiPartType<?> getType() {
        return ModContent.redstoneTorchPartType;
    }

    @Override
    protected Block getStandingBlock() {
        return Blocks.field_150429_aA;
    }

    @Override
    protected Block getWallBlock() {
        return Blocks.field_196677_cy;
    }

    public boolean active() {
        return (Boolean)this.state.func_177229_b((Property)RedstoneTorchBlock.field_196528_a);
    }

    @Override
    public void animateTick(Random random) {
        if (!this.active()) {
            return;
        }
        super.animateTick(random);
    }

    @Override
    public void onNeighborBlockChanged(BlockPos from) {
        if (!this.world().field_72995_K && !this.dropIfCantStay() && this.isBeingPowered() == this.active()) {
            this.scheduleTick(2);
        }
    }

    public boolean isBeingPowered() {
        return RedstoneInteractions.getPowerTo(this, this.getSide().ordinal()) > 0;
    }

    @Override
    public void scheduledTick() {
        if (!this.world().field_72995_K && this.isBeingPowered() == this.active()) {
            this.toggle();
        }
    }

    @Override
    public void randomTick() {
        this.scheduledTick();
    }

    @Override
    public void onChunkLoad(Chunk chunk) {
        TickScheduler.loadRandomTick(this, chunk);
    }

    @Override
    public void onWorldJoin() {
        TickScheduler.loadRandomTick(this);
    }

    private boolean burnedOut(boolean add) {
        BurnoutEntry b;
        long time = this.world().func_82737_E();
        while (this.burnout != null && this.burnout.timeout <= time) {
            this.burnout = this.burnout.next;
        }
        if (add) {
            BurnoutEntry e = new BurnoutEntry(this.world().func_82737_E() + 60L);
            if (this.burnout == null) {
                this.burnout = e;
            } else {
                b = this.burnout;
                while (b.next != null) {
                    b = b.next;
                }
                b.next = e;
            }
        }
        if (this.burnout == null) {
            return false;
        }
        int i = 0;
        b = this.burnout;
        while (b != null) {
            ++i;
            b = b.next;
        }
        return i >= 8;
    }

    private void toggle() {
        if (this.active()) {
            if (this.burnedOut(true)) {
                this.world().func_217379_c(1502, this.pos(), 0);
            }
        } else if (this.burnedOut(false)) {
            return;
        }
        this.state = (BlockState)this.state.func_206870_a((Property)RedstoneTorchBlock.field_196528_a, (Comparable)Boolean.valueOf(!this.active()));
        this.sendUpdate(this::writeDesc);
        this.tile().func_70296_d();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(1);
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
        this.onNeighborBlockChanged(this.pos());
    }

    @Override
    public int strongPowerLevel(int side) {
        return side == 1 && this.active() ? 15 : 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() && side != this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    public static class BurnoutEntry {
        long timeout;
        BurnoutEntry next;

        public BurnoutEntry(long l) {
            this.timeout = l;
        }
    }
}

