/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.platform.forge;

import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.shedaniel.architectury.platform.Mod;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl {
    private static final Map<String, Mod> mods = new ConcurrentHashMap<String, Mod>();

    public static Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getModsFolder() {
        return FMLPaths.MODSDIR.get();
    }

    public static Env getEnvironment() {
        return Env.fromPlatform(PlatformImpl.getEnv());
    }

    public static Dist getEnv() {
        return FMLEnvironment.dist;
    }

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    public static Mod getMod(String id) {
        return mods.computeIfAbsent(id, ModImpl::new);
    }

    public static Collection<Mod> getMods() {
        for (IModInfo mod : ModList.get().getMods()) {
            PlatformImpl.getMod(mod.getModId());
        }
        return mods.values();
    }

    public static Collection<String> getModIds() {
        return ModList.get().getMods().stream().map(ModInfo::getModId).collect(Collectors.toList());
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    private static class ModImpl
    implements Mod {
        private final ModContainer container;
        private final ModInfo info;

        public ModImpl(String id) {
            this.container = (ModContainer)ModList.get().getModContainerById(id).orElseThrow(() -> new NoSuchElementException("No value present"));
            this.info = ModList.get().getMods().stream().filter(modInfo -> Objects.equals(modInfo.getModId(), id)).findAny().orElseThrow(() -> new NoSuchElementException("No value present"));
        }

        @Override
        @Nonnull
        public String getModId() {
            return this.info.getModId();
        }

        @Override
        @Nonnull
        public String getVersion() {
            return this.info.getVersion().toString();
        }

        @Override
        @Nonnull
        public String getName() {
            return this.info.getDisplayName();
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.info.getDescription();
        }

        @Override
        @NotNull
        public Optional<String> getLogoFile(int i) {
            return this.info.getLogoFile();
        }

        @Override
        @NotNull
        public Path getFilePath() {
            return this.info.getOwningFile().getFile().getFilePath();
        }

        @Override
        @NotNull
        public Collection<String> getAuthors() {
            Optional<String> optional = this.info.getConfigElement(new String[]{"authors"}).map(String::valueOf);
            return optional.isPresent() ? Collections.singleton(optional.get()) : Collections.emptyList();
        }

        @Override
        @Nullable
        public Collection<String> getLicense() {
            return Collections.singleton(this.info.getOwningFile().getLicense());
        }

        @Override
        @NotNull
        public Optional<String> getHomepage() {
            return this.info.getConfigElement(new String[]{"displayURL"}).map(String::valueOf);
        }

        @Override
        @NotNull
        public Optional<String> getSources() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<String> getIssueTracker() {
            return Optional.ofNullable(this.info.getOwningFile().getIssueURL()).map(URL::toString);
        }

        @Override
        public void registerConfigurationScreen(Mod.ConfigurationScreenProvider configurationScreenProvider) {
            this.container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (minecraft, screen) -> configurationScreenProvider.provide((Screen)screen));
        }
    }
}

