/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class VoxelShapeComponentsFactoryHandlerParts
implements VoxelShapeComponentsFactory.IHandler {
    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, IBlockReader world, BlockPos blockPos) {
        ArrayList components = Lists.newArrayList();
        for (Direction direction : Direction.values()) {
            IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(world, blockPos, direction).orElse(null);
            if (partContainer == null || !partContainer.hasPart(direction)) continue;
            components.add(new Component(direction, partContainer));
        }
        return components;
    }

    public static class Component
    implements VoxelShapeComponents.IComponent {
        private final Direction direction;
        private final IPartContainer partContainer;

        public Component(Direction direction, IPartContainer partContainer) {
            this.direction = direction;
            this.partContainer = partContainer;
        }

        @Override
        public String getStateId(BlockState blockState, IBlockReader world, BlockPos blockPos) {
            return "part(" + this.partContainer.getPart(this.direction).getPartRenderPosition().toCompactString() + ")";
        }

        @Override
        public VoxelShape getShape(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
            return this.partContainer.getPart(this.direction).getPartRenderPosition().getBoundingBox(this.direction);
        }

        @Override
        public ItemStack getPickBlock(World world, BlockPos pos) {
            return this.partContainer.getPart(this.direction).getPickBlock(world, pos, this.partContainer.getPartState(this.direction));
        }

        @Override
        public boolean destroy(World world, BlockPos pos, PlayerEntity player, boolean saveState) {
            if (!world.func_201670_d()) {
                return PartHelpers.removePart(world, pos, this.direction, player, true, true, saveState);
            }
            return false;
        }

        @Override
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public IBakedModel getBreakingBaseModel(World world, BlockPos pos) {
            BlockState cableState = this.partContainer != null ? this.partContainer.getPart(this.direction).getBlockState(this.partContainer, this.direction) : null;
            return RenderHelpers.getBakedModel(cableState);
        }

        @Override
        public ActionResultType onBlockActivated(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (WrenchHelpers.isWrench(player, heldItem, world, blockPos, hit.func_216354_b()) && player.func_226563_dT_()) {
                if (!world.func_201670_d()) {
                    this.destroy(world, blockPos, player, true);
                    ItemBlockCable.playBreakSound(world, blockPos, state);
                }
                return ActionResultType.SUCCESS;
            }
            if (CableHelpers.isNoFakeCable((IBlockReader)world, blockPos, hit.func_216354_b())) {
                return this.partContainer.getPart(this.direction).onPartActivated(this.partContainer.getPartState(this.direction), blockPos, world, player, hand, heldItem, hit.func_216351_a(this.direction));
            }
            return ActionResultType.PASS;
        }

        @Override
        @Nullable
        public Direction getRaytraceDirection() {
            return this.direction;
        }

        @Override
        public boolean isRaytraceLastForFace() {
            return false;
        }
    }
}

