/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public class ValueTypeListProxyTail<T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final IValueTypeListProxy<T, V> list;

    public ValueTypeListProxyTail(IValueTypeListProxy<T, V> list) {
        super(ValueTypeListProxyFactories.TAIL.getName(), list.getValueType());
        this.list = list;
    }

    @Override
    public int getLength() throws EvaluationException {
        return Math.max(0, this.list.getLength() - 1);
    }

    @Override
    public V get(int index) throws EvaluationException {
        int listLength = this.list.getLength();
        if (index < listLength - 1) {
            return this.list.get(index + 1);
        }
        return null;
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<IValueType<IValue>, IValue, ValueTypeListProxyTail<IValueType<IValue>, IValue>> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "tail");
        }

        @Override
        protected void serializeNbt(ValueTypeListProxyTail<IValueType<IValue>, IValue> value, CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.func_218657_a("sublist", ValueTypeListProxyFactories.REGISTRY.serialize(((ValueTypeListProxyTail)value).list));
        }

        @Override
        protected ValueTypeListProxyTail<IValueType<IValue>, IValue> deserializeNbt(CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException, EvaluationException {
            Object list = ValueTypeListProxyFactories.REGISTRY.deserialize(tag.func_74781_a("sublist"));
            return new ValueTypeListProxyTail<IValueType<IValue>, IValue>((IValueTypeListProxy<IValueType<IValue>, IValue>)list);
        }
    }
}

