/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.entity.item.EntityItemTargetted;
import org.cyclops.integrateddynamics.inventory.container.ContainerOnTheDynamicsOfIntegration;
import org.cyclops.integrateddynamics.item.ItemOnTheDynamicsOfIntegrationConfig;

public class ItemOnTheDynamicsOfIntegration
extends ItemGui {
    private static final int SPAWN_RANGE = 25;
    private static final String NBT_INFOBOOK_SPAWNED = "integrateddynamics:infoBookSpawned";

    public ItemOnTheDynamicsOfIntegration(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    @Nullable
    public INamedContainerProvider getContainer(World world, PlayerEntity playerEntity, int itemIndex, Hand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.infobook"), ContainerOnTheDynamicsOfIntegration::new);
    }

    public Class<? extends Container> getContainerClass(World world, PlayerEntity playerEntity, ItemStack itemStack) {
        return ContainerOnTheDynamicsOfIntegration.class;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ItemOnTheDynamicsOfIntegrationConfig.obtainOnSpawn) {
            CompoundNBT playerTag;
            CompoundNBT tag = event.getPlayer().getPersistentData();
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            if (!(playerTag = tag.func_74775_l("PlayerPersisted")).func_74764_b(NBT_INFOBOOK_SPAWNED)) {
                playerTag.func_74757_a(NBT_INFOBOOK_SPAWNED, true);
                World world = event.getPlayer().func_130014_f_();
                PlayerEntity player = event.getPlayer();
                ItemStack itemStack = new ItemStack((IItemProvider)RegistryEntries.ITEM_ON_THE_DYNAMICS_OF_INTEGRATION);
                EntityItemTargetted entity = new EntityItemTargetted(world, (float)(player.func_233580_cy_().func_177958_n() + 25) - 50.0f * world.field_73012_v.nextFloat(), (float)player.func_233580_cy_().func_177956_o() + 25.0f * world.field_73012_v.nextFloat(), (float)(player.func_233580_cy_().func_177952_p() + 25) - 50.0f * world.field_73012_v.nextFloat());
                entity.func_92058_a(itemStack);
                entity.setTarget((LivingEntity)player);
                world.func_217376_c((Entity)entity);
            }
        }
    }
}

